/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/effects/Move.as
 * org.apache.flex.effects.Move
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.effects.Move');

goog.require('org.apache.flex.effects.Tween');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam target Object ID or reference to an object that will
 *  have its x and/or y property animated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.effects.Tween}
 * @implements {org.apache.flex.core.IDocument}
 * @param {org.apache.flex.core.IUIBase=} target
 */
org.apache.flex.effects.Move = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.effects.Move.base(this, 'constructor');
  this.actualTarget = target;
  this.startValue = 0;
  this.endValue = 1;
  this.listener = this;
};
goog.inherits(org.apache.flex.effects.Move, org.apache.flex.effects.Tween);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.effects.Move.prototype.document;


/**
 * @private
 * @type {org.apache.flex.core.IUIBase}
 */
org.apache.flex.effects.Move.prototype.actualTarget;


/**
 * @export
 * @type {string}
 */
org.apache.flex.effects.Move.prototype.target;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.xBy;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.yBy;


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.xStart;


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.yStart;


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.xMove;


/**
 * @private
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.yMove;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.xFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.xTo;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.yFrom;


/**
 * @export
 * @type {number}
 */
org.apache.flex.effects.Move.prototype.yTo;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.effects.Move.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.effects.Move.prototype.play = function() {
  if (this.target != null)
    this.actualTarget = this.document[this.target];
  if (isNaN(this.xFrom))
    this.xStart = this.actualTarget.x;
  else
    this.xStart = this.xFrom;
  if (isNaN(this.xBy)) {
    if (isNaN(this.xTo))
      this.xMove = 0;
    else
      this.xMove = this.xTo - this.xStart;
  }
  else
    this.xMove = this.xBy;
  if (isNaN(this.yFrom))
    this.yStart = this.actualTarget.y;
  else
    this.yStart = this.yFrom;
  if (isNaN(this.yBy)) {
    if (isNaN(this.yTo))
      this.yMove = 0;
    else
      this.yMove = this.yTo - this.yStart;
  }
  else
    this.yMove = this.yBy;
  org.apache.flex.effects.Move.base(this, 'play');
};


/**
 * @export
 * @param {number} value
 */
org.apache.flex.effects.Move.prototype.onTweenUpdate = function(value) {
  if (this.xMove)
    this.actualTarget.x = this.xStart + value * this.xMove;
  if (this.yMove)
    this.actualTarget.y = this.yStart + value * this.yMove;
};


/**
 * @export
 * @param {number} value
 */
org.apache.flex.effects.Move.prototype.onTweenEnd = function(value) {
  if (this.xMove)
    this.actualTarget.x = this.xStart + this.xMove;
  if (this.yMove)
    this.actualTarget.y = this.yStart + this.yMove;
};


/**
 * @export
 * @override
 */
org.apache.flex.effects.Move.prototype.captureStartValues = function() {
  if (this.target != null) {
    this.actualTarget = this.document[this.target];
    this.xFrom = this.actualTarget.x;
    this.yFrom = this.actualTarget.y;
  }
};


/**
 * @export
 * @override
 */
org.apache.flex.effects.Move.prototype.captureEndValues = function() {
  if (this.target != null) {
    this.actualTarget = this.document[this.target];
    this.xTo = this.actualTarget.x;
    this.yTo = this.actualTarget.y;
  }
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.effects.Move.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Move', qName: 'org.apache.flex.effects.Move'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.effects.Move', org.apache.flex.effects.Move);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.effects.Move.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'target': { type: 'String'},
        'xBy': { type: 'Number'},
        'yBy': { type: 'Number'},
        'xFrom': { type: 'Number'},
        'xTo': { type: 'Number'},
        'yFrom': { type: 'Number'},
        'yTo': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Move': { type: '', declaredBy: 'org.apache.flex.effects.Move'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.effects.Move'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.effects.Move'},
        'onTweenUpdate': { type: 'void', declaredBy: 'org.apache.flex.effects.Move'},
        'onTweenEnd': { type: 'void', declaredBy: 'org.apache.flex.effects.Move'},
        'captureStartValues': { type: 'void', declaredBy: 'org.apache.flex.effects.Move'},
        'captureEndValues': { type: 'void', declaredBy: 'org.apache.flex.effects.Move'}
      };
    }
  };
};