/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/controllers/DropMouseController.as
 * org.apache.flex.html.beads.controllers.DropMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.controllers.DropMouseController');

goog.require('org.apache.flex.events.DragEvent');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.events.MouseEvent');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.html.beads.controllers.DropMouseController = function() {
  org.apache.flex.html.beads.controllers.DropMouseController.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.controllers.DropMouseController, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype._strand;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.inside;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.dragSource;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.dragInitiator;


/**
 * @export
 * @param {org.apache.flex.core.IUIBase} target
 * @param {string} type
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.acceptDragDrop = function(target, type) {
};


/**
 *  @asprivate
 * @flexjsignorecoercion org.apache.flex.events.MouseEvent
 * @private
 * @param {org.apache.flex.events.DragEvent} event
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.dragMoveHandler = function(event) {
  org.apache.flex.utils.Language.trace("dragMove");
  var /** @type {org.apache.flex.events.DragEvent} */ dragEvent;
  if (!this.inside) {
    dragEvent = org.apache.flex.events.DragEvent.createDragEvent("dragEnter", event);
    this.dispatchEvent(dragEvent);
    this.inside = true;
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase, true).topMostEventDispatcher.addEventListener(org.apache.flex.events.DragEvent.DRAG_END, org.apache.flex.utils.Language.closure(this.dragEndHandler, this, 'dragEndHandler'));
    org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase, true).addEventListener(org.apache.flex.events.MouseEvent.ROLL_OUT, org.apache.flex.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'));
  } else {
    dragEvent = org.apache.flex.events.DragEvent.createDragEvent("dragOver", event);
    this.dispatchEvent(dragEvent);
  }
};


/**
 * @private
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.rollOutHandler = function(event) {
  var /** @type {org.apache.flex.events.DragEvent} */ dragEvent;
  if (this.inside) {
    dragEvent = org.apache.flex.events.DragEvent.createDragEvent("dragExit", event);
    this.dispatchEvent(dragEvent);
    this.inside = false;
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase, true).topMostEventDispatcher.removeEventListener(org.apache.flex.events.DragEvent.DRAG_END, org.apache.flex.utils.Language.closure(this.dragEndHandler, this, 'dragEndHandler'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase, true).removeEventListener(org.apache.flex.events.MouseEvent.ROLL_OUT, org.apache.flex.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'));
};


/**
 * @flexjsignorecoercion org.apache.flex.events.MouseEvent
 * @private
 * @param {org.apache.flex.events.DragEvent} event
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.dragEndHandler = function(event) {
  org.apache.flex.utils.Language.trace("dragEnd");
  var /** @type {org.apache.flex.events.DragEvent} */ dragEvent;
  dragEvent = org.apache.flex.events.DragEvent.createDragEvent("dragDrop", event);
  this.dispatchEvent(dragEvent);
  this.inside = false;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase, true).topMostEventDispatcher.removeEventListener(org.apache.flex.events.DragEvent.DRAG_END, org.apache.flex.utils.Language.closure(this.dragEndHandler, this, 'dragEndHandler'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase, true).removeEventListener(org.apache.flex.events.MouseEvent.ROLL_OUT, org.apache.flex.utils.Language.closure(this.rollOutHandler, this, 'rollOutHandler'));
};


Object.defineProperties(org.apache.flex.html.beads.controllers.DropMouseController.prototype, /** @lends {org.apache.flex.html.beads.controllers.DropMouseController.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.html.beads.controllers.DropMouseController} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.html.beads.controllers.DropMouseController} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener(org.apache.flex.events.DragEvent.DRAG_MOVE, org.apache.flex.utils.Language.closure(this.dragMoveHandler, this, 'dragMoveHandler'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DropMouseController', qName: 'org.apache.flex.html.beads.controllers.DropMouseController'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.controllers.DropMouseController', org.apache.flex.html.beads.controllers.DropMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.controllers.DropMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.controllers.DropMouseController'}
      };
    },
    methods: function () {
      return {
        'DropMouseController': { type: '', declaredBy: 'org.apache.flex.html.beads.controllers.DropMouseController'},
        'acceptDragDrop': { type: 'void', declaredBy: 'org.apache.flex.html.beads.controllers.DropMouseController'}
      };
    },
    metadata: function () { return [ ]; }
  };
};