/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/core/View.as
 * org.apache.flex.createjs.core.View
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.core.View');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.createjs.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.IApplicationView');
goog.require('org.apache.flex.core.IContainer');
goog.require('org.apache.flex.core.IPopUpHost');
goog.require('org.apache.flex.core.IStatesImpl');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.createjs.core.UIBase}
 * @implements {org.apache.flex.core.IPopUpHost}
 * @implements {org.apache.flex.core.IApplicationView}
 * @implements {org.apache.flex.core.IContainer}
 */
org.apache.flex.createjs.core.View = function() {
  org.apache.flex.createjs.core.View.base(this, 'constructor');

this._mxmlDocument = this;
};
goog.inherits(org.apache.flex.createjs.core.View, org.apache.flex.createjs.core.UIBase);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.core.View.prototype._applicationModel;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion createjs.Container
 * @protected
 * @override
 */
org.apache.flex.createjs.core.View.prototype.createElement = function() {
  if (this.element == null) {
    var /** @type {createjs.Container} */ container = new createjs.Container();
    container.name = 'viewbase';
    container.x = 0;
    container.y = 0;
    this.element = container;
  }
  if (this.positioner == null) {
    this.positioner = this.element;
  }
  this.element.flexjs_wrapper = this;
  return this.positioner;
};


/**
 * @export
 */
org.apache.flex.createjs.core.View.prototype.childrenAdded = function() {
  this.dispatchEvent(new org.apache.flex.events.Event("childrenAdded"));
};


/**
 *  A ViewBase doesn't create its children until it is added to
 *  a parent.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.createjs.core.View.prototype.addedToParent = function() {
  if (!this._initialized) {
    org.apache.flex.core.ValuesManager.valuesImpl.init(this);
  }
  org.apache.flex.createjs.core.View.base(this, 'addedToParent');
  if (!this._initialized) {
    org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this._mxmlDocument, this, this.MXMLDescriptor);
    this.dispatchEvent(new org.apache.flex.events.Event("initBindings"));
    this.dispatchEvent(new org.apache.flex.events.Event("initComplete"));
    this._initialized = true;
  }
};


/**
 * @private
 * @type {Array}
 */
org.apache.flex.createjs.core.View.prototype._mxmlDescriptor;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.core.View.prototype._mxmlDocument;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.createjs.core.View.prototype._initialized;


/**
 *  @asprivate
 * @export
 * @param {Object} document
 * @param {Array} value
 */
org.apache.flex.createjs.core.View.prototype.setMXMLDescriptor = function(document, value) {
  this._mxmlDocument = document;
  this._mxmlDescriptor = value;
};


/**
 *  @copy org.apache.flex.core.Application#generateMXMLAttributes()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Array} data
 */
org.apache.flex.createjs.core.View.prototype.generateMXMLAttributes = function(data) {
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, data);
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.createjs.core.View.prototype.mxmlContent;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.createjs.core.View.prototype._states;


/**
 *  <code>true</code> if the array of states
 *  contains a state with this name.
 * 
 *  @asparam state The state namem.
 *  @asreturn True if state in state array
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} state
 * @return {boolean}
 */
org.apache.flex.createjs.core.View.prototype.hasState = function(state) {
  var foreachiter0_target = this._states;
  for (var foreachiter0 in foreachiter0_target) 
  {
  var s = foreachiter0_target[foreachiter0];
  {
    if (s.name == state)
      return true;
  }}
  
  return false;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.core.View.prototype._currentState;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.createjs.core.View.prototype._transitions;


Object.defineProperties(org.apache.flex.createjs.core.View.prototype, /** @lends {org.apache.flex.createjs.core.View.prototype} */ {
/** @export */
applicationModel: {
get: /** @this {org.apache.flex.createjs.core.View} */ function() {
  return this._applicationModel;
},
set: /** @this {org.apache.flex.createjs.core.View} */ function(value) {
  this._applicationModel = value;
  this.dispatchEvent(new org.apache.flex.events.Event("modelChanged"));
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.createjs.core.View} */ function() {
  return this._mxmlDescriptor;
}},
/** @export */
states: {
get: /** @this {org.apache.flex.createjs.core.View} */ function() {
  return this._states;
},
set: /** @this {org.apache.flex.createjs.core.View} */ function(value) {
  this._states = value;
  this._currentState = org.apache.flex.utils.Language.string(this._states[0].name);
  try {
    if (this.getBeadByType(org.apache.flex.core.IStatesImpl) == null) {
      var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iStatesImpl");
      var /** @type {Object} */ b = new c();
      this.addBead(b);
    }
  } catch (e) {
  }
}},
/** @export */
currentState: {
get: /** @this {org.apache.flex.createjs.core.View} */ function() {
  return this._currentState;
},
set: /** @this {org.apache.flex.createjs.core.View} */ function(value) {
  var /** @type {org.apache.flex.events.ValueChangeEvent} */ event = new org.apache.flex.events.ValueChangeEvent("currentStateChange", false, false, this._currentState, value);
  this._currentState = value;
  this.dispatchEvent(event);
}},
/** @export */
transitions: {
get: /** @this {org.apache.flex.createjs.core.View} */ function() {
  return this._transitions;
},
set: /** @this {org.apache.flex.createjs.core.View} */ function(value) {
  this._transitions = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.core.View.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'View', qName: 'org.apache.flex.createjs.core.View'}], interfaces: [org.apache.flex.core.IPopUpHost, org.apache.flex.core.IApplicationView, org.apache.flex.core.IContainer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.core.View', org.apache.flex.createjs.core.View);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.core.View.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'mxmlContent': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'applicationModel': { type: 'Object', declaredBy: 'org.apache.flex.createjs.core.View', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'modelChanged'}]}]; }},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.createjs.core.View'},
        'states': { type: 'Array', declaredBy: 'org.apache.flex.createjs.core.View'},
        'currentState': { type: 'String', declaredBy: 'org.apache.flex.createjs.core.View', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'currentStateChange'}]}]; }},
        'transitions': { type: 'Array', declaredBy: 'org.apache.flex.createjs.core.View'}
      };
    },
    methods: function () {
      return {
        'childrenAdded': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.View'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.View'},
        'setMXMLDescriptor': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.View'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.createjs.core.View'},
        'hasState': { type: 'Boolean', declaredBy: 'org.apache.flex.createjs.core.View'}
      };
    }
  };
};