/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/Application.as
 * org.apache.flex.createjs.Application
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.Application');

goog.require('org.apache.flex.core.ApplicationBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.core.IStrand');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * FalconJX will inject html into the index.html file.  Surround with
 * "inject_html" tag as follows:
 *
 * <inject_html>
 * <script src="https://code.createjs.com/easeljs-0.8.1.min.js"></script>
 * <script src="https://code.createjs.com/tweenjs-0.6.2.min.js"></script>
 * </inject_html>
 * @constructor
 * @extends {org.apache.flex.core.ApplicationBase}
 * @implements {org.apache.flex.core.IStrand}
 * @implements {org.apache.flex.core.IParent}
 * @implements {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.createjs.Application = function() {
  org.apache.flex.createjs.Application.base(this, 'constructor');
};
goog.inherits(org.apache.flex.createjs.Application, org.apache.flex.core.ApplicationBase);


/**
 * @private
 * @type {createjs.Stage}
 */
org.apache.flex.createjs.Application.prototype.stage;


/**
 * @asprivate
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLBodyElement
 * @flexjsignorecoercion HTMLCanvasElement
 * @flexjsignorecoercion createjs.Stage
 * @export
 */
org.apache.flex.createjs.Application.prototype.start = function() {
  var /** @type {HTMLBodyElement} */ body;
  var /** @type {HTMLCanvasElement} */ canvas;
  this.element = document.createElement('canvas');
  this.element.flexjs_wrapper = this;
  canvas = this.element;
  canvas.id = 'flexjsCanvas';
  canvas.width = 700;
  canvas.height = 500;
  body = document.getElementsByTagName('body')[0];
  body.appendChild(this.element);
  this.stage = new createjs.Stage('flexjsCanvas');
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this, null, this.MXMLDescriptor);
  this.dispatchEvent('initialize');
  for (var /** @type {number} */ index in this.beads) {
    this.addBead(this.beads[index]);
  }
  this.dispatchEvent(new org.apache.flex.events.Event("beadsAdded"));
  this.initialView.applicationModel = this.model;
  this.addElement(this.initialView);
  this.dispatchEvent('viewChanged');
  this.stage.update();
  this.dispatchEvent('applicationComplete');
};


/**
 * @export
 * @type {org.apache.flex.core.IApplicationView}
 */
org.apache.flex.createjs.Application.prototype.initialView;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.Application.prototype._model;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.createjs.Application.prototype.controller;


/**
 *  An method called by the compiler's generated
 *  code to kick off the setting of MXML attribute
 *  values and instantiation of child tags.
 *
 *  The call has to be made in the generated code
 *  in order to ensure that the constructors have
 *  completed first.
 *
 *  @asparam data The encoded data representing the
 *  MXML attributes.
 *
 *  @see org.apache.flex.utils.MXMLDataInterpreter
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Array} data
 */
org.apache.flex.createjs.Application.prototype.generateMXMLAttributes = function(data) {
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, data);
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.createjs.Application.prototype.beads;


/**
 *  @copy org.apache.flex.core.IParent#addElement()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.createjs.Application.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.stage.addChild(c.element);
  c.addedToParent();
};


/**
 *  @copy org.apache.flex.core.IParent#addElementAt()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.createjs.Application.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.stage.addChildAt(c.element, index);
  c.addedToParent();
};


/**
 *  @copy org.apache.flex.core.IParent#getElementAt()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.createjs.Application.prototype.getElementAt = function(index) {
  var /** @type {Object} */ c = this.stage.getChildAt(index);
  return c.flexjs_wrapper;
};


/**
 *  @copy org.apache.flex.core.IParent#getElementIndex()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion createjs.DisplayObject
 * @export
 * @param {Object} c
 * @return {number}
 */
org.apache.flex.createjs.Application.prototype.getElementIndex = function(c) {
  return this.stage.getChildIndex(c.element);
};


/**
 *  @copy org.apache.flex.core.IParent#removeElement()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.createjs.Application.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.stage.removeChild(org.apache.flex.utils.Language.as(c.element, createjs.DisplayObject));
};


Object.defineProperties(org.apache.flex.createjs.Application.prototype, /** @lends {org.apache.flex.createjs.Application.prototype} */ {
/** @export */
valuesImpl: {
set: /** @this {org.apache.flex.createjs.Application} */ function(value) {
  org.apache.flex.core.ValuesManager.valuesImpl = value;
  org.apache.flex.core.ValuesManager.valuesImpl.init(this);
}},
/** @export */
model: {
get: /** @this {org.apache.flex.createjs.Application} */ function() {
  return this._model;
},
set: /** @this {org.apache.flex.createjs.Application} */ function(value) {
  this._model = value;
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.createjs.Application} */ function() {
  return null;
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.createjs.Application} */ function() {
  return this.stage.numChildren;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.Application.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Application', qName: 'org.apache.flex.createjs.Application'}], interfaces: [org.apache.flex.core.IStrand, org.apache.flex.core.IParent, org.apache.flex.events.IEventDispatcher] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.Application', org.apache.flex.createjs.Application);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.Application.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'initialView': { type: 'IApplicationView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'controller': { type: 'Object'},
        'beads': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'valuesImpl': { type: 'IValuesImpl', declaredBy: 'org.apache.flex.createjs.Application'},
        'model': { type: 'Object', declaredBy: 'org.apache.flex.createjs.Application', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.createjs.Application'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.createjs.Application'}
      };
    },
    methods: function () {
      return {
        'Application': { type: '', declaredBy: 'org.apache.flex.createjs.Application'},
        'start': { type: 'void', declaredBy: 'org.apache.flex.createjs.Application'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.createjs.Application'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.createjs.Application'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.createjs.Application'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.createjs.Application'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.createjs.Application'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.createjs.Application'}
      };
    }
  };
};