/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/StringPadder.as
 * org.apache.flex.utils.StringPadder
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.StringPadder');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 */
org.apache.flex.utils.StringPadder = function() {
};


/**
 *  Pads a string with an arbitrary string.
 *
 *  @asparam str The string to be padded.
 *
 *  @asparam padChar The character used to pad the string. This should be a single character.
 *
 *  @asparam size The size of the padded string.
 *
 *  @asparam padRight Which side to add the padding on. By default it's added to the left.
 *
 *  @asreturn The padded string.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4.1
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} str
 * @param {string} padChar
 * @param {number} size
 * @param {boolean=} padRight
 * @return {string}
 */
org.apache.flex.utils.StringPadder.pad = function(str, padChar, size, padRight) {
  padRight = typeof padRight !== 'undefined' ? padRight : false;
  str = str ? str : "";
  size += 1;
  size -= str.length;
  var /** @type {string} */ p = new Array(size).join(padChar);
  if (padRight)
    return str + p;
  else
    return p + str;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.StringPadder.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'StringPadder', qName: 'org.apache.flex.utils.StringPadder'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.StringPadder', org.apache.flex.utils.StringPadder);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.StringPadder.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
      };
    }
  };
};