/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/states/SetProperty.as
 * org.apache.flex.states.SetProperty
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.states.SetProperty');

goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.states.SetProperty = function() {
  ;
};


/**
 * @export
 * @type {string}
 */
org.apache.flex.states.SetProperty.prototype.target;


/**
 * @export
 * @type {string}
 */
org.apache.flex.states.SetProperty.prototype.name;


/**
 * @export
 * @type {*}
 */
org.apache.flex.states.SetProperty.prototype.value;


/**
 * @export
 * @type {*}
 */
org.apache.flex.states.SetProperty.prototype.previousValue;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.states.SetProperty.prototype.document;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.states.SetProperty.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 * @asprivate 
 * Initialize this object from a descriptor.
 * @export
 * @param {Object} properties
 * @return {Object}
 */
org.apache.flex.states.SetProperty.prototype.initializeFromObject = function(properties) {
  for (var /** @type {string} */ p in properties) {
    this[p] = properties[p];
  }
  return Object(this);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.states.SetProperty.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SetProperty', qName: 'org.apache.flex.states.SetProperty'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.states.SetProperty', org.apache.flex.states.SetProperty);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.states.SetProperty.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'target': { type: 'String'},
        'name': { type: 'String'},
        'value': { type: '*'},
        'previousValue': { type: '*'},
        'document': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'SetProperty': { type: '', declaredBy: 'org.apache.flex.states.SetProperty'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.states.SetProperty'},
        'initializeFromObject': { type: 'Object', declaredBy: 'org.apache.flex.states.SetProperty'}
      };
    },
    metadata: function () { return [ ]; }
  };
};