/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/geom/Point.as
 * org.apache.flex.geom.Point
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.geom.Point');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {number=} x
 * @param {number=} y
 */
org.apache.flex.geom.Point = function(x, y) {
  x = typeof x !== 'undefined' ? x : 0;
  y = typeof y !== 'undefined' ? y : 0;
  this.x = x;
  this.y = y;
};


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Point.prototype.x;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Point.prototype.y;


/**
 * @export
 * @param {org.apache.flex.geom.Point} pt1
 * @param {org.apache.flex.geom.Point} pt2
 * @param {number} f
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Point.interpolate = function(pt1, pt2, f) {
  return new org.apache.flex.geom.Point(pt2.x + f * (pt1.x - pt2.x), pt2.y + f * (pt1.y - pt2.y));
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} pt1
 * @param {org.apache.flex.geom.Point} pt2
 * @return {number}
 */
org.apache.flex.geom.Point.distance = function(pt1, pt2) {
  return pt1.subtract(pt2).length;
};


/**
 * @export
 * @param {number} len
 * @param {number} angle
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Point.polar = function(len, angle) {
  return new org.apache.flex.geom.Point(len * Math.cos(angle), len * Math.sin(angle));
};


/**
 * @export
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Point.prototype.clone = function() {
  return new org.apache.flex.geom.Point(this.x, this.y);
};


/**
 * @export
 * @param {number} dx
 * @param {number} dy
 */
org.apache.flex.geom.Point.prototype.offset = function(dx, dy) {
  this.x = this.x + dx;
  this.y = this.y + dy;
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} toCompare
 * @return {boolean}
 */
org.apache.flex.geom.Point.prototype.equals = function(toCompare) {
  return toCompare.x == this.x && toCompare.y == this.y;
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} v
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Point.prototype.subtract = function(v) {
  return new org.apache.flex.geom.Point(this.x - v.x, this.y - v.y);
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} v
 * @return {org.apache.flex.geom.Point}
 */
org.apache.flex.geom.Point.prototype.add = function(v) {
  return new org.apache.flex.geom.Point(this.x + v.x, this.y + v.y);
};


/**
 * @export
 * @param {number} thickness
 */
org.apache.flex.geom.Point.prototype.normalize = function(thickness) {
  var /** @type {number} */ invD = this.length;
  if (invD > 0) {
    invD = thickness / invD;
    this.x = this.x * invD;
    this.y = this.y * invD;
  }
};


/**
 * @export
 * @return {string}
 */
org.apache.flex.geom.Point.prototype.toString = function() {
  return "(x=" + this.x + ", y=" + this.y + ")";
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} sourcePoint
 */
org.apache.flex.geom.Point.prototype.copyFrom = function(sourcePoint) {
  this.x = sourcePoint.x;
  this.y = sourcePoint.y;
};


/**
 * @export
 * @param {number} xa
 * @param {number} ya
 */
org.apache.flex.geom.Point.prototype.setTo = function(xa, ya) {
  this.x = xa;
  this.y = ya;
};


Object.defineProperties(org.apache.flex.geom.Point.prototype, /** @lends {org.apache.flex.geom.Point.prototype} */ {
/** @export */
length: {
get: /** @this {org.apache.flex.geom.Point} */ function() {
  return Math.sqrt(this.x * this.x + this.y * this.y);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.geom.Point.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Point', qName: 'org.apache.flex.geom.Point'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.geom.Point', org.apache.flex.geom.Point);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.geom.Point.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'x': { type: 'Number'},
        'y': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
        'length': { type: 'Number', declaredBy: 'org.apache.flex.geom.Point'}
      };
    },
    methods: function () {
      return {
        'Point': { type: '', declaredBy: 'org.apache.flex.geom.Point'},
        'clone': { type: 'Point', declaredBy: 'org.apache.flex.geom.Point'},
        'offset': { type: 'void', declaredBy: 'org.apache.flex.geom.Point'},
        'equals': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Point'},
        'subtract': { type: 'Point', declaredBy: 'org.apache.flex.geom.Point'},
        'add': { type: 'Point', declaredBy: 'org.apache.flex.geom.Point'},
        'normalize': { type: 'void', declaredBy: 'org.apache.flex.geom.Point'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.geom.Point'},
        'copyFrom': { type: 'void', declaredBy: 'org.apache.flex.geom.Point'},
        'setTo': { type: 'void', declaredBy: 'org.apache.flex.geom.Point'}
      };
    }
  };
};