/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/ContainerBase.as
 * org.apache.flex.core.ContainerBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.ContainerBase');

goog.require('org.apache.flex.core.ContainerBaseStrandChildren');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.core.IContainer');
goog.require('org.apache.flex.core.IContentViewHost');
goog.require('org.apache.flex.core.IMXMLDocument');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.core.IStatesImpl');
goog.require('org.apache.flex.core.IStatesObject');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.core.IMXMLDocument}
 * @implements {org.apache.flex.core.IStatesObject}
 * @implements {org.apache.flex.core.IContainer}
 * @implements {org.apache.flex.core.IContentViewHost}
 */
org.apache.flex.core.ContainerBase = function() {
  
  this._mxmlDocument = this;
  org.apache.flex.core.ContainerBase.base(this, 'constructor');
  this._strandChildren = new org.apache.flex.core.ContainerBaseStrandChildren(this);
};
goog.inherits(org.apache.flex.core.ContainerBase, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {org.apache.flex.core.ContainerBaseStrandChildren}
 */
org.apache.flex.core.ContainerBase.prototype._strandChildren;


/**
 *  @copy org.apache.flex.core.IParent#getElementAt()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.core.ContainerBase.prototype.getElementAt = function(index) {
  var /** @type {org.apache.flex.core.IParent} */ contentView = org.apache.flex.utils.Language.as(this.view, org.apache.flex.core.IParent);
  if (contentView != null) {
    return contentView.getElementAt(index);
  } else {
    return org.apache.flex.core.ContainerBase.base(this, 'getElementAt', index);
  }
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.core.ContainerBase.prototype.getElementIndex = function(c) {
  var /** @type {org.apache.flex.core.IParent} */ contentView = org.apache.flex.utils.Language.as(this.view, org.apache.flex.core.IParent);
  if (contentView != null) {
    return contentView.getElementIndex(c);
  } else {
    return org.apache.flex.core.ContainerBase.base(this, 'getElementIndex', c);
  }
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.core.ContainerBase.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  var /** @type {org.apache.flex.core.IParent} */ contentView = org.apache.flex.utils.Language.as(this.view, org.apache.flex.core.IParent);
  if (contentView != null) {
    contentView.addElement(c, dispatchEvent);
    if (dispatchEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("childrenAdded"));
  } else {
    org.apache.flex.core.ContainerBase.base(this, 'addElement', c);
  }
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.core.ContainerBase.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  var /** @type {org.apache.flex.core.IParent} */ contentView = org.apache.flex.utils.Language.as(this.view, org.apache.flex.core.IParent);
  if (contentView != null) {
    contentView.addElementAt(c, index, dispatchEvent);
    if (dispatchEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("childrenAdded"));
  } else {
    org.apache.flex.core.ContainerBase.base(this, 'addElementAt', c, index);
  }
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.core.ContainerBase.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  var /** @type {org.apache.flex.core.IParent} */ contentView = org.apache.flex.utils.Language.as(this.view, org.apache.flex.core.IParent);
  if (contentView != null) {
    contentView.removeElement(c, dispatchEvent);
    if (dispatchEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("childrenRemoved"));
  } else {
    org.apache.flex.core.ContainerBase.base(this, 'removeElement', c);
  }
};


/**
 *  @asprivate
 * @export
 */
org.apache.flex.core.ContainerBase.prototype.childrenAdded = function() {
  this.dispatchEvent(new org.apache.flex.events.Event("childrenAdded"));
};


/**
 *  A ContainerBase doesn't create its children until it is added to
 *  a parent.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.core.ContainerBase.prototype.addedToParent = function() {
  if (!this._initialized) {
    org.apache.flex.core.ValuesManager.valuesImpl.init(this);
  }
  org.apache.flex.core.ContainerBase.base(this, 'addedToParent');
  if (!this._initialized) {
    org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this._mxmlDocument, this, this.MXMLDescriptor);
    this.dispatchEvent(new org.apache.flex.events.Event("initBindings"));
    this.dispatchEvent(new org.apache.flex.events.Event("initComplete"));
    this._initialized = true;
  }
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @return {number}
 */
org.apache.flex.core.ContainerBase.prototype.$numElements = function() {
  return org.apache.flex.core.ContainerBase.base(this, 'numElements');
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.ContainerBase.prototype.$addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.flex.core.ContainerBase.base(this, 'addElement', c, dispatchEvent);
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {Object} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.ContainerBase.prototype.$addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.flex.core.ContainerBase.base(this, 'addElementAt', c, index, dispatchEvent);
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.ContainerBase.prototype.$removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  org.apache.flex.core.ContainerBase.base(this, 'removeElement', c, dispatchEvent);
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {Object} c
 * @return {number}
 */
org.apache.flex.core.ContainerBase.prototype.$getElementIndex = function(c) {
  return org.apache.flex.core.ContainerBase.base(this, 'getElementIndex', c);
};


/**
 * @asprivate
 * @suppress {undefinedNames}
 * Support strandChildren.
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.core.ContainerBase.prototype.$getElementAt = function(index) {
  return org.apache.flex.core.ContainerBase.base(this, 'getElementAt', index);
};


/**
 * @private
 * @type {Array}
 */
org.apache.flex.core.ContainerBase.prototype._mxmlDescriptor;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.core.ContainerBase.prototype._mxmlDocument;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.core.ContainerBase.prototype._initialized;


/**
 *  @asprivate
 * @export
 * @param {Object} document
 * @param {Array} value
 */
org.apache.flex.core.ContainerBase.prototype.setMXMLDescriptor = function(document, value) {
  this._mxmlDocument = document;
  this._mxmlDescriptor = value;
};


/**
 *  @copy org.apache.flex.core.Application#generateMXMLAttributes()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Array} data
 */
org.apache.flex.core.ContainerBase.prototype.generateMXMLAttributes = function(data) {
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, data);
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.core.ContainerBase.prototype.mxmlContent;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.core.ContainerBase.prototype._states;


/**
 *  <code>true</code> if the array of states
 *  contains a state with this name.
 * 
 *  @asparam state The state namem.
 *  @asreturn True if state in state array
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} state
 * @return {boolean}
 */
org.apache.flex.core.ContainerBase.prototype.hasState = function(state) {
  var foreachiter0_target = this._states;
  for (var foreachiter0 in foreachiter0_target) 
  {
  var s = foreachiter0_target[foreachiter0];
  {
    if (s.name == state)
      return true;
  }}
  
  return false;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.ContainerBase.prototype._currentState;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.core.ContainerBase.prototype._transitions;


Object.defineProperties(org.apache.flex.core.ContainerBase.prototype, /** @lends {org.apache.flex.core.ContainerBase.prototype} */ {
/** @export */
strandChildren: {
get: /** @this {org.apache.flex.core.ContainerBase} */ function() {
  return this._strandChildren;
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.core.ContainerBase} */ function() {
  return this._mxmlDescriptor;
}},
/** @export */
states: {
get: /** @this {org.apache.flex.core.ContainerBase} */ function() {
  return this._states;
},
set: /** @this {org.apache.flex.core.ContainerBase} */ function(value) {
  this._states = value;
  this._currentState = org.apache.flex.utils.Language.string(this._states[0].name);
  try {
    if (this.getBeadByType(org.apache.flex.core.IStatesImpl) == null) {
      var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iStatesImpl");
      var /** @type {Object} */ b = new c();
      this.addBead(b);
    }
  } catch (e) {
    
  }
}},
/** @export */
currentState: {
get: /** @this {org.apache.flex.core.ContainerBase} */ function() {
  return this._currentState;
},
set: /** @this {org.apache.flex.core.ContainerBase} */ function(value) {
  var /** @type {org.apache.flex.events.ValueChangeEvent} */ event = new org.apache.flex.events.ValueChangeEvent("currentStateChange", false, false, this._currentState, value);
  this._currentState = value;
  this.dispatchEvent(event);
}},
/** @export */
transitions: {
get: /** @this {org.apache.flex.core.ContainerBase} */ function() {
  return this._transitions;
},
set: /** @this {org.apache.flex.core.ContainerBase} */ function(value) {
  this._transitions = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.ContainerBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ContainerBase', qName: 'org.apache.flex.core.ContainerBase'}], interfaces: [org.apache.flex.core.IMXMLDocument, org.apache.flex.core.IStatesObject, org.apache.flex.core.IContainer, org.apache.flex.core.IContentViewHost] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.ContainerBase', org.apache.flex.core.ContainerBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.ContainerBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'mxmlContent': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'strandChildren': { type: 'IParent', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'states': { type: 'Array', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'currentState': { type: 'String', declaredBy: 'org.apache.flex.core.ContainerBase', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'currentStateChange'}]}]; }},
        'transitions': { type: 'Array', declaredBy: 'org.apache.flex.core.ContainerBase'}
      };
    },
    methods: function () {
      return {
        'ContainerBase': { type: '', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'childrenAdded': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        '$numElements': { type: 'int', declaredBy: 'org.apache.flex.core.ContainerBase'},
        '$addElement': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        '$addElementAt': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        '$removeElement': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        '$getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.core.ContainerBase'},
        '$getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'setMXMLDescriptor': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.core.ContainerBase'},
        'hasState': { type: 'Boolean', declaredBy: 'org.apache.flex.core.ContainerBase'}
      };
    },
    metadata: function () { return [ ]; }
  };
};