/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/CallLaterBead.as
 * org.apache.flex.core.CallLaterBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.CallLaterBead');

goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.core.CallLaterBead = function() {
  ;
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.core.CallLaterBead.prototype._strand;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.core.CallLaterBead.prototype.calls;


/**
 *  Calls a function after some amount of time.
 * 
 *  CallLater works a bit differently than in
 *  the Flex SDK.  The Flex SDK version was
 *  could use the Flash Player's RENDER event 
 *  to try to run code before the scren was
 *  updated.  Since there is no deferred rendering
 *  in HTML/JS/CSS, this version of callLater
 *  is almost always going to run after the
 *  screen is updated.
 *  
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Function} fn
 * @param {Array=} args
 * @param {Object=} thisArg
 */
org.apache.flex.core.CallLaterBead.prototype.callLater = function(fn, args, thisArg) {
  args = typeof args !== 'undefined' ? args : null;
  thisArg = typeof thisArg !== 'undefined' ? thisArg : null;
  
  if (this.calls == null)
    this.calls = [{thisArg:thisArg, fn:fn, args:args}];
  else
    this.calls.push({thisArg:thisArg, fn:fn, args:args});
  setTimeout(org.apache.flex.utils.Language.closure(this.makeCalls, this, 'makeCalls'), 0);
};


/**
 * @private
 */
org.apache.flex.core.CallLaterBead.prototype.makeCalls = function() {
  var /** @type {Array} */ list = this.calls;
  var /** @type {number} */ n = list.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {Object} */ call = list.shift();
    var /** @type {Function} */ fn = call.fn;
    fn.apply(call.thisArg, call.args);
  }
};


Object.defineProperties(org.apache.flex.core.CallLaterBead.prototype, /** @lends {org.apache.flex.core.CallLaterBead.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.core.CallLaterBead} */ function(value) {
  this._strand = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.CallLaterBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CallLaterBead', qName: 'org.apache.flex.core.CallLaterBead'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.CallLaterBead', org.apache.flex.core.CallLaterBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.CallLaterBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.core.CallLaterBead'}
      };
    },
    methods: function () {
      return {
        'CallLaterBead': { type: '', declaredBy: 'org.apache.flex.core.CallLaterBead'},
        'callLater': { type: 'void', declaredBy: 'org.apache.flex.core.CallLaterBead'}
      };
    }
  };
};