/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/Application.as
 * org.apache.flex.core.Application
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.Application');

goog.require('org.apache.flex.core.ApplicationBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.utils.MXMLDataInterpreter');
goog.require('org.apache.flex.utils.Timer');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.core.IStrand');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.ApplicationBase}
 * @implements {org.apache.flex.core.IStrand}
 * @implements {org.apache.flex.core.IParent}
 * @implements {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.core.Application = function() {
  org.apache.flex.core.Application.base(this, 'constructor');
  
};
goog.inherits(org.apache.flex.core.Application, org.apache.flex.core.ApplicationBase);


/**
 * @export
 * @type {org.apache.flex.core.IApplicationView}
 */
org.apache.flex.core.Application.prototype.initialView;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.core.Application.prototype._model;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.Application.prototype.controller;


/**
 *  An method called by the compiler's generated
 *  code to kick off the setting of MXML attribute
 *  values and instantiation of child tags.
 *
 *  The call has to be made in the generated code
 *  in order to ensure that the constructors have
 *  completed first.
 *
 *  @asparam data The encoded data representing the
 *  MXML attributes.
 *
 *  @see org.apache.flex.utils.MXMLDataInterpreter
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Array} data
 */
org.apache.flex.core.Application.prototype.generateMXMLAttributes = function(data) {
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLProperties(this, data);
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.core.Application.prototype.beads;


/**
 *  @copy org.apache.flex.core.IParent#addElement()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.Application.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  
  this.element.appendChild(c.element);
  c.addedToParent();
};


/**
 *  @copy org.apache.flex.core.IParent#addElementAt()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.Application.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  
  var /** @type {NodeList} */ children = this.internalChildren();
  if (index >= children.length)
    this.addElement(c); else {
    this.element.insertBefore(c.positioner, children[index]);
    c.addedToParent();
  }
};


/**
 *  @copy org.apache.flex.core.IParent#getElementAt()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.core.Application.prototype.getElementAt = function(index) {
  
  var /** @type {NodeList} */ children = this.internalChildren();
  return children[index].flexjs_wrapper;
};


/**
 *  @copy org.apache.flex.core.IParent#getElementIndex()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @return {number}
 */
org.apache.flex.core.Application.prototype.getElementIndex = function(c) {
  
  var /** @type {NodeList} */ children = this.internalChildren();
  var /** @type {number} */ n = children.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    if (children[i] == c.element)
      return i;
  }
  return -1;
};


/**
 *  @copy org.apache.flex.core.IParent#removeElement()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.Application.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  
  this.element.removeChild(c.element);
};


/**
 * @asreturn {Object} The array of children.
 * @protected
 * @return {NodeList}
 */
org.apache.flex.core.Application.prototype.internalChildren = function() {
  return this.element.childNodes;
};


/**
 * @protected
 * @type {org.apache.flex.utils.Timer}
 */
org.apache.flex.core.Application.prototype.startupTimer;


/**
 * @flexjsignorecoercion org.apache.flex.core.IBead
 * @export
 */
org.apache.flex.core.Application.prototype.start = function() {
  this.element = document.getElementsByTagName('body')[0];
  this.element.flexjs_wrapper = this;
  this.element.className = 'Application';
  if (org.apache.flex.utils.Language.is(this.model, org.apache.flex.core.IBead))
    this.addBead(this.model);
  if (org.apache.flex.utils.Language.is(this.controller, org.apache.flex.core.IBead))
    this.addBead(this.controller);
  for (var /** @type {number} */ index in this.beads) {
    this.addBead(this.beads[index]);
  }
  this.dispatchEvent(new org.apache.flex.events.Event("beadsAdded"));
  if (this.dispatchEvent(new org.apache.flex.events.Event("preinitialize", false, true)))
    this.initialize(); else {
    this.startupTimer = new org.apache.flex.utils.Timer(34, 0);
    this.startupTimer.addEventListener("timer", org.apache.flex.utils.Language.closure(this.handleStartupTimer, this, 'handleStartupTimer'));
    this.startupTimer.start();
  }
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.core.Application.prototype.handleStartupTimer = function(event) {
  if (this.dispatchEvent(new org.apache.flex.events.Event("preinitialize", false, true))) {
    this.startupTimer.stop();
    this.initialize();
  }
};


/**
 * @flexjsignorecoercion org.apache.flex.core.IBead
 * @protected
 */
org.apache.flex.core.Application.prototype.initialize = function() {
  org.apache.flex.utils.MXMLDataInterpreter.generateMXMLInstances(this, null, this.MXMLDescriptor);
  this.dispatchEvent('initialize');
  this.initialView.applicationModel = this.model;
  this.addElement(this.initialView);
  if (this.initialView) {
    var /** @type {org.apache.flex.core.UIBase} */ baseView = org.apache.flex.utils.Language.as(this.initialView, org.apache.flex.core.UIBase);
    if (!isNaN(baseView.percentWidth) || !isNaN(baseView.percentHeight)) {
      this.element.style.height = window.innerHeight.toString() + 'px';
      this.element.style.width = window.innerWidth.toString() + 'px';
      this.initialView.dispatchEvent('sizeChanged');
    }
    this.dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
  }
  this.dispatchEvent(new org.apache.flex.events.Event("applicationComplete"));
};


Object.defineProperties(org.apache.flex.core.Application.prototype, /** @lends {org.apache.flex.core.Application.prototype} */ {
/** @export */
valuesImpl: {
set: /** @this {org.apache.flex.core.Application} */ function(value) {
  org.apache.flex.core.ValuesManager.valuesImpl = value;
  org.apache.flex.core.ValuesManager.valuesImpl.init(this);
}},
/** @export */
model: {
get: /** @this {org.apache.flex.core.Application} */ function() {
  return this._model;
},
set: /** @this {org.apache.flex.core.Application} */ function(value) {
  this._model = value;
}},
/** @export */
MXMLDescriptor: {
get: /** @this {org.apache.flex.core.Application} */ function() {
  return null;
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.core.Application} */ function() {
  
  var /** @type {NodeList} */ children = this.internalChildren();
  return children.length;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.Application.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Application', qName: 'org.apache.flex.core.Application'}], interfaces: [org.apache.flex.core.IStrand, org.apache.flex.core.IParent, org.apache.flex.events.IEventDispatcher] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.Application', org.apache.flex.core.Application);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.Application.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'initialView': { type: 'IApplicationView', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'controller': { type: 'Object'},
        'beads': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'valuesImpl': { type: 'IValuesImpl', declaredBy: 'org.apache.flex.core.Application'},
        'model': { type: 'Object', declaredBy: 'org.apache.flex.core.Application', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: '__NoChangeEvent__'}]}]; }},
        'MXMLDescriptor': { type: 'Array', declaredBy: 'org.apache.flex.core.Application'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.core.Application'}
      };
    },
    methods: function () {
      return {
        'Application': { type: '', declaredBy: 'org.apache.flex.core.Application'},
        'generateMXMLAttributes': { type: 'void', declaredBy: 'org.apache.flex.core.Application'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.core.Application'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.core.Application'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.core.Application'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.core.Application'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.core.Application'},
        'start': { type: 'void', declaredBy: 'org.apache.flex.core.Application'}
      };
    },
    metadata: function () { return [ ]; }
  };
};