/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/collections/LazyCollection.as
 * org.apache.flex.collections.LazyCollection
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.collections.LazyCollection');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.collections.ICollection');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.collections.ICollection}
 */
org.apache.flex.collections.LazyCollection = function() {
  org.apache.flex.collections.LazyCollection.base(this, 'constructor');
};
goog.inherits(org.apache.flex.collections.LazyCollection, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.collections.parsers.IInputParser}
 */
org.apache.flex.collections.LazyCollection.prototype._inputParser;


/**
 * @private
 * @type {org.apache.flex.collections.converters.IItemConverter}
 */
org.apache.flex.collections.LazyCollection.prototype._itemConverter;


/**
 * @private
 * @type {string}
 */
org.apache.flex.collections.LazyCollection.prototype._id;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.collections.LazyCollection.prototype._strand;


/**
 * @protected
 * @type {Array}
 */
org.apache.flex.collections.LazyCollection.prototype.rawData;


/**
 * @protected
 * @type {Array}
 */
org.apache.flex.collections.LazyCollection.prototype.data;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.collections.LazyCollection.prototype.completeHandler = function(event) {
  this.rawData = this.inputParser.parseItems(this._strand["data"]);
  this.data = new Array(this.rawData.length);
  this.dispatchEvent(event);
};


/**
 *  Fetches an item from the collection, converting it first if necessary.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.collections.LazyCollection.prototype.getItemAt = function(index) {
  if (this.data[index] == undefined) {
    this.data[index] = this.itemConverter.convertItem(this.rawData[index]);
  }
  return this.data[index];
};


Object.defineProperties(org.apache.flex.collections.LazyCollection.prototype, /** @lends {org.apache.flex.collections.LazyCollection.prototype} */ {
/** @export */
inputParser: {
get: /** @this {org.apache.flex.collections.LazyCollection} */ function() {
  return this._inputParser;
},
set: /** @this {org.apache.flex.collections.LazyCollection} */ function(value) {
  if (this._inputParser != value) {
    this._inputParser = value;
    this.dispatchEvent(new org.apache.flex.events.Event("inputParserChanged"));
  }
}},
/** @export */
itemConverter: {
get: /** @this {org.apache.flex.collections.LazyCollection} */ function() {
  return this._itemConverter;
},
set: /** @this {org.apache.flex.collections.LazyCollection} */ function(value) {
  if (this._itemConverter != value) {
    this._itemConverter = value;
    this.dispatchEvent(new org.apache.flex.events.Event("itemConverterChanged"));
  }
}},
/** @export */
id: {
get: /** @this {org.apache.flex.collections.LazyCollection} */ function() {
  return this._id;
},
set: /** @this {org.apache.flex.collections.LazyCollection} */ function(value) {
  if (this._id != value) {
    this._id = value;
    this.dispatchEvent(new org.apache.flex.events.Event("idChanged"));
  }
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.collections.LazyCollection} */ function(value) {
  this._strand = value;
  
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("complete", org.apache.flex.utils.Language.closure(this.completeHandler, this, 'completeHandler'));
}},
/** @export */
length: {
get: /** @this {org.apache.flex.collections.LazyCollection} */ function() {
  return this.rawData ? this.rawData.length : 0;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.collections.LazyCollection.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LazyCollection', qName: 'org.apache.flex.collections.LazyCollection'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.collections.ICollection] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.collections.LazyCollection', org.apache.flex.collections.LazyCollection);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.collections.LazyCollection.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'inputParser': { type: 'IInputParser', declaredBy: 'org.apache.flex.collections.LazyCollection'},
        'itemConverter': { type: 'IItemConverter', declaredBy: 'org.apache.flex.collections.LazyCollection'},
        'id': { type: 'String', declaredBy: 'org.apache.flex.collections.LazyCollection'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.collections.LazyCollection'},
        'length': { type: 'int', declaredBy: 'org.apache.flex.collections.LazyCollection'}
      };
    },
    methods: function () {
      return {
        'LazyCollection': { type: '', declaredBy: 'org.apache.flex.collections.LazyCollection'},
        'getItemAt': { type: 'Object', declaredBy: 'org.apache.flex.collections.LazyCollection'}
      };
    },
    metadata: function () { return [ ]; }
  };
};