/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/controllers/ChartSeriesMouseController.as
 * org.apache.flex.charts.beads.controllers.ChartSeriesMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.controllers.ChartSeriesMouseController');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.charts.core.IChartDataModel');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController = function() {
};


/**
 * @protected
 * @type {org.apache.flex.charts.core.IChartDataModel}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.listModel;


/**
 * @protected
 * @type {org.apache.flex.html.beads.IListView}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.listView;


/**
 * @protected
 * @type {org.apache.flex.core.IItemRendererParent}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.dataGroup;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype._strand;


/**
 * @protected
 * @param {org.apache.flex.events.ItemAddedEvent} event
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.handleItemAdded = function(event) {
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemClicked", org.apache.flex.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemRollOver", org.apache.flex.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemRollOut", org.apache.flex.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @protected
 * @param {org.apache.flex.events.ItemAddedEvent} event
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.handleItemRemoved = function(event) {
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).removeEventListener("itemClicked", org.apache.flex.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).removeEventListener("itemRollOver", org.apache.flex.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  org.apache.flex.utils.Language.as(event.item, org.apache.flex.events.IEventDispatcher, true).removeEventListener("itemRollOut", org.apache.flex.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @protected
 * @param {org.apache.flex.events.ItemClickedEvent} event
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.selectedHandler = function(event) {
  var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ renderer = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.charts.core.IChartItemRenderer);
  if (renderer) {
    this.listModel.selectedSeries = renderer.series;
    this.listModel.selectedIndex = event.index;
    this.listView.host.dispatchEvent(new org.apache.flex.events.Event("change"));
  }
};


/**
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.rolloverHandler = function(event) {
  var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ renderer = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.charts.core.IChartItemRenderer);
  if (renderer) {
    this.listModel.rollOverSeries = renderer.series;
    this.listModel.rollOverIndex = renderer.index;
  }
};


/**
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.rolloutHandler = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ renderer = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (renderer) {
    renderer.hovered = false;
    renderer.down = false;
    this.listModel.rollOverSeries = null;
    this.listModel.rollOverIndex = -1;
  }
};


Object.defineProperties(org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype, /** @lends {org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.charts.beads.controllers.ChartSeriesMouseController} */ function(value) {
  this._strand = value;
  this.listModel = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.charts.core.IChartDataModel), org.apache.flex.charts.core.IChartDataModel);
  this.listView = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemAdded", org.apache.flex.utils.Language.closure(this.handleItemAdded, this, 'handleItemAdded'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("itemRemoved", org.apache.flex.utils.Language.closure(this.handleItemRemoved, this, 'handleItemRemoved'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChartSeriesMouseController', qName: 'org.apache.flex.charts.beads.controllers.ChartSeriesMouseController'}], interfaces: [org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.controllers.ChartSeriesMouseController', org.apache.flex.charts.beads.controllers.ChartSeriesMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.controllers.ChartSeriesMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.controllers.ChartSeriesMouseController'}
      };
    },
    methods: function () {
      return {
        'ChartSeriesMouseController': { type: '', declaredBy: 'org.apache.flex.charts.beads.controllers.ChartSeriesMouseController'}
      };
    }
  };
};