/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/DataTipBead.as
 * org.apache.flex.charts.beads.DataTipBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.DataTipBead');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.MouseEvent');
goog.require('org.apache.flex.events.utils.MouseUtils');
goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.html.accessories.ToolTipBead');
goog.require('org.apache.flex.utils.PointUtils');
goog.require('org.apache.flex.charts.core.IChartDataGroup');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.accessories.ToolTipBead}
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.charts.beads.DataTipBead = function() {
  org.apache.flex.charts.beads.DataTipBead.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.beads.DataTipBead, org.apache.flex.html.accessories.ToolTipBead);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.DataTipBead.prototype._strand;


/**
 * @private
 * @type {Function}
 */
org.apache.flex.charts.beads.DataTipBead.prototype._labelFunction;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.DataTipBead.prototype.handleViewCreated = function(event) {
  var /** @type {org.apache.flex.html.beads.IListView} */ chart = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  var /** @type {org.apache.flex.charts.core.IChartDataGroup} */ dataGroup = org.apache.flex.utils.Language.as(chart.dataGroup, org.apache.flex.charts.core.IChartDataGroup);
  org.apache.flex.utils.Language.as(dataGroup, org.apache.flex.events.IEventDispatcher, true).addEventListener(org.apache.flex.events.MouseEvent.MOUSE_OVER, org.apache.flex.utils.Language.closure(this.rollOverHandler, this, 'rollOverHandler'));
};


/**
 * @asprivate
 * Overrides the ToolTipBead's function to determine the text to display
 * based on the chart series and current value.
 * @protected
 * @override
 */
org.apache.flex.charts.beads.DataTipBead.prototype.rollOverHandler = function(event) {
  var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ renderer = this.findItemRenderer(event);
  if (renderer) {
    var /** @type {org.apache.flex.charts.core.IChartSeries} */ series = renderer.series;
    var /** @type {string} */ result;
    if (this.labelFunction) {
      result = org.apache.flex.utils.Language.string(this.labelFunction(renderer));
    } else {
      if (series.xField)
        result = org.apache.flex.utils.Language.string(renderer.data[series.xField]);
      else if (series.yField)
        result = org.apache.flex.utils.Language.string(renderer.data[series.yField]);
    }
    this.toolTip = result;
    org.apache.flex.charts.beads.DataTipBead.base(this, 'rollOverHandler', event);
  }
};


/**
 * @asprivate
 * Override's the ToolTipBead's function to position the data tip just above
 * the itemRenderer.
 * @protected
 * @override
 */
org.apache.flex.charts.beads.DataTipBead.prototype.determinePosition = function(event, base) {
  var /** @type {org.apache.flex.geom.Point} */ pt = new org.apache.flex.geom.Point(0, -20);
  pt = org.apache.flex.utils.PointUtils.localToGlobal(pt, base);
  return pt;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.MouseEvent} event
 * @return {org.apache.flex.charts.core.IChartItemRenderer}
 */
org.apache.flex.charts.beads.DataTipBead.prototype.findItemRenderer = function(event) {
  var /** @type {Object} */ base = org.apache.flex.events.utils.MouseUtils.eventTarget(event);
  if (org.apache.flex.utils.Language.is(base, org.apache.flex.charts.core.IChartDataGroup)) {
    var /** @type {org.apache.flex.charts.core.IChartDataGroup} */ dataGroup = org.apache.flex.utils.Language.as(base, org.apache.flex.charts.core.IChartDataGroup);
    var /** @type {org.apache.flex.geom.Point} */ point = new org.apache.flex.geom.Point(event.localX, event.localY);
    var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ renderer = dataGroup.getItemRendererUnderPoint(point);
    return renderer;
  } else {
    var /** @type {org.apache.flex.core.UIBase} */ chain = org.apache.flex.utils.Language.as(base, org.apache.flex.core.UIBase);
    while (chain != null && !org.apache.flex.utils.Language.is(chain, org.apache.flex.charts.core.IChartItemRenderer)) {
      chain = org.apache.flex.utils.Language.as(chain.parent, org.apache.flex.core.UIBase);
    }
    return org.apache.flex.utils.Language.as(chain, org.apache.flex.charts.core.IChartItemRenderer);
  }
};


Object.defineProperties(org.apache.flex.charts.beads.DataTipBead.prototype, /** @lends {org.apache.flex.charts.beads.DataTipBead.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.charts.beads.DataTipBead} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.beads.DataTipBead, this, 'strand', value);
  this._strand = value;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("viewCreated", org.apache.flex.utils.Language.closure(this.handleViewCreated, this, 'handleViewCreated'));
}},
/** @export */
labelFunction: {
get: /** @this {org.apache.flex.charts.beads.DataTipBead} */ function() {
  return this._labelFunction;
},
set: /** @this {org.apache.flex.charts.beads.DataTipBead} */ function(value) {
  this._labelFunction = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.DataTipBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataTipBead', qName: 'org.apache.flex.charts.beads.DataTipBead'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.DataTipBead', org.apache.flex.charts.beads.DataTipBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.DataTipBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.DataTipBead'},
        'labelFunction': { type: 'Function', declaredBy: 'org.apache.flex.charts.beads.DataTipBead'}
      };
    },
    methods: function () {
      return {
        'DataTipBead': { type: '', declaredBy: 'org.apache.flex.charts.beads.DataTipBead'}
      };
    }
  };
};