/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/ChartItemRendererFactory.as
 * org.apache.flex.charts.beads.ChartItemRendererFactory
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.ChartItemRendererFactory');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.charts.core.IChart');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.charts.core.IChartSeries');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDataProviderItemRendererMapper');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDataProviderItemRendererMapper}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ISelectionModel}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory.prototype.selectionModel;


/**
 * @protected
 * @type {org.apache.flex.core.IItemRendererParent}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory.prototype.dataGroup;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory.prototype._seriesRenderers;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory.prototype._strand;


Object.defineProperties(org.apache.flex.charts.beads.ChartItemRendererFactory.prototype, /** @lends {org.apache.flex.charts.beads.ChartItemRendererFactory.prototype} */ {
/** @export */
seriesRenderers: {
get: /** @this {org.apache.flex.charts.beads.ChartItemRendererFactory} */ function() {
  return this._seriesRenderers;
},
set: /** @this {org.apache.flex.charts.beads.ChartItemRendererFactory} */ function(value) {
  this._seriesRenderers = value;
}},
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.ChartItemRendererFactory} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.ChartItemRendererFactory} */ function(value) {
  this._strand = value;
  this.selectionModel = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {org.apache.flex.html.beads.IListView} */ listView = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  this.dataGroup = listView.dataGroup;
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(this.selectionModel.dataProvider, Array);
  if (!dp)
    return;
  this._seriesRenderers = new Array();
  this.dataGroup.removeAllElements();
  var /** @type {Array} */ series = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.charts.core.IChart, true).series;
  for (var /** @type {number} */ j = 0; j < dp.length; j++) {
    var /** @type {Array} */ renderers = new Array();
    for (var /** @type {number} */ i = 0; i < series.length; i++) {
      var /** @type {org.apache.flex.charts.core.IChartSeries} */ s = org.apache.flex.utils.Language.as(series[i], org.apache.flex.charts.core.IChartSeries);
      var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ k = org.apache.flex.utils.Language.as(s.itemRenderer.newInstance(), org.apache.flex.charts.core.IChartItemRenderer);
      k.itemRendererParent = this.dataGroup;
      k.xField = s.xField;
      k.yField = s.yField;
      k.data = dp[j];
      renderers.push(k);
      this.dataGroup.addElement(k);
    }
    this._seriesRenderers.push(renderers);
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("itemsCreated"));
}},
/** @export */
itemRendererFactory: {
get: /** @this {org.apache.flex.charts.beads.ChartItemRendererFactory} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.beads.ChartItemRendererFactory} */ function(value) {
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChartItemRendererFactory', qName: 'org.apache.flex.charts.beads.ChartItemRendererFactory'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDataProviderItemRendererMapper] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.ChartItemRendererFactory', org.apache.flex.charts.beads.ChartItemRendererFactory);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.ChartItemRendererFactory.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'seriesRenderers': { type: 'Array', declaredBy: 'org.apache.flex.charts.beads.ChartItemRendererFactory'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.ChartItemRendererFactory'},
        'itemRendererFactory': { type: 'IItemRendererClassFactory', declaredBy: 'org.apache.flex.charts.beads.ChartItemRendererFactory'}
      };
    },
    methods: function () {
      return {
        'ChartItemRendererFactory': { type: '', declaredBy: 'org.apache.flex.charts.beads.ChartItemRendererFactory'}
      };
    }
  };
};