/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/binding/WatcherBase.as
 * org.apache.flex.binding.WatcherBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.binding.WatcherBase');

goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 */
org.apache.flex.binding.WatcherBase = function() {
  ;
};


/**
 * @protected
 * @type {Array}
 */
org.apache.flex.binding.WatcherBase.prototype.listeners;


/**
 * @protected
 * @type {Array}
 */
org.apache.flex.binding.WatcherBase.prototype.children;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.WatcherBase.prototype.value;


/**
 *  This is an abstract method that subclasses implement.  Implementations
 *  handle changes in the parent chain.  For example, if watching 
 *  {a.b.c} and this watcher is watching "b", then handle "a" changing.
 *
 *  @asparam parent The new parent.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} parent
 */
org.apache.flex.binding.WatcherBase.prototype.parentChanged = function(parent) {
};


/**
 *  Add a child to this watcher, meaning that the child
 *  is watching a sub value of ours.  For example, if watching 
 *  {a.b.c} and this watcher is watching "b", then this method
 *  is called to add the watcher watching "c".
 *
 *  @asparam child The new child
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.binding.WatcherBase} child
 */
org.apache.flex.binding.WatcherBase.prototype.addChild = function(child) {
  if (!this.children)
    this.children = [child];
  else
    this.children.push(child);
  child.parentChanged(this);
};


/**
 *  Add a binding to this watcher, meaning that the binding
 *  is notified when our value changes.  Bindings are classes
 *  that actually perform the change based on changes
 *  detected to this portion of the chain.
 *
 *  @asparam binding The new binding.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.binding.GenericBinding} binding
 */
org.apache.flex.binding.WatcherBase.prototype.addBinding = function(binding) {
  if (!this.listeners)
    this.listeners = [binding];
  else
    this.listeners.push(binding);
  binding.valueChanged(this.value);
};


/**
 *  This method is called when the value
 *  might have changed and goes through
 *  and makes sure the children are updated.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.binding.WatcherBase.prototype.updateChildren = function() {
  if (this.children) {
    var /** @type {number} */ n = this.children.length;
    for (var /** @type {number} */ i = 0; i < n; ++i) {
      this.children[i].parentChanged(this);
    }
  }
};


/**
 *  @asprivate
 * @private
 * @param {Object} oldval
 * @return {boolean}
 */
org.apache.flex.binding.WatcherBase.prototype.valueChanged = function(oldval) {
  if (oldval == null && this.value == null)
    return false;
  var /** @type {string} */ valType = typeof(this.value);
  if (valType == "string") {
    if (oldval == null && this.value == "")
      return false;
    else
      return oldval != this.value;
  }
  if (valType == "number") {
    if (oldval == null && this.value == 0)
      return false;
    else
      return oldval != this.value;
  }
  if (valType == "boolean") {
    if (oldval == null && this.value == false)
      return false;
    else
      return oldval != this.value;
  }
  return true;
};


/**
 *  Calls a function inside a try catch block to try to
 *  update the value.
 *
 *  @asparam wrappedFunction The function to call.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {Function} wrappedFunction
 */
org.apache.flex.binding.WatcherBase.prototype.wrapUpdate = function(wrappedFunction) {
  try {
    wrappedFunction.apply(this);
  } catch (error) {
    var /** @type {number} */ n = org.apache.flex.binding.WatcherBase.allowedErrorTypes.length;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      if (org.apache.flex.utils.Language.is(error, org.apache.flex.binding.WatcherBase.allowedErrorTypes[i].type)) {
        var /** @type {Function} */ handler = org.apache.flex.binding.WatcherBase.allowedErrorTypes[i].handler;
        if (handler != null)
          this.value = handler(this, wrappedFunction);
        else
          this.value = null;
      }
    }
    
    var /** @type {string} */ s = error.message;
    n = org.apache.flex.binding.WatcherBase.allowedErrors.length;
    for (i = 0; i < n; i++) {
      if (s.indexOf(org.apache.flex.binding.WatcherBase.allowedErrors[i]) != -1)
        return;
    }
    throw error;
  }
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.binding.WatcherBase.allowedErrors = ["Call attempted on an object that is not a function.", "null has no properties.", "undefined has no properties.", "has no properties.", "and there is no default value", "invalid null argument."];


/**
 * @export
 * @type {Array}
 */
org.apache.flex.binding.WatcherBase.allowedErrorTypes = [{type:RangeError}];


/**
 *  Notify the various bindings that the value has changed so they can update
 *  their data binding expressions.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.binding.WatcherBase.prototype.notifyListeners = function() {
  if (this.listeners) {
    var /** @type {number} */ n = this.listeners.length;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      this.listeners[i].valueChanged(this.value);
    }
  }
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.WatcherBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'WatcherBase', qName: 'org.apache.flex.binding.WatcherBase'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.WatcherBase', org.apache.flex.binding.WatcherBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.WatcherBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'value': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'WatcherBase': { type: '', declaredBy: 'org.apache.flex.binding.WatcherBase'},
        'parentChanged': { type: 'void', declaredBy: 'org.apache.flex.binding.WatcherBase'},
        'addChild': { type: 'void', declaredBy: 'org.apache.flex.binding.WatcherBase'},
        'addBinding': { type: 'void', declaredBy: 'org.apache.flex.binding.WatcherBase'},
        'updateChildren': { type: 'void', declaredBy: 'org.apache.flex.binding.WatcherBase'},
        'notifyListeners': { type: 'void', declaredBy: 'org.apache.flex.binding.WatcherBase'}
      };
    }
  };
};