/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/binding/PropertyWatcher.as
 * org.apache.flex.binding.PropertyWatcher
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.binding.PropertyWatcher');

goog.require('org.apache.flex.binding.WatcherBase');
goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @asparam source The object who's property we are watching.
 *  @asparam proeprtyName The name of the property we are watching.
 *  @asparam eventNames The name or array of names of events that get
 *  dispatched when the property changes.
 *  @asparam getterFunction  A function to call to get the value
 *  of the property changes if the property is not public.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.binding.WatcherBase}
 * @param {Object} source
 * @param {string} propertyName
 * @param {Object} eventNames
 * @param {Function} getterFunction
 */
org.apache.flex.binding.PropertyWatcher = function(source, propertyName, eventNames, getterFunction) {
  org.apache.flex.binding.PropertyWatcher.base(this, 'constructor');
  this.source = source;
  this.propertyName = propertyName;
  this.getterFunction = getterFunction;
  this.eventNames = eventNames;
};
goog.inherits(org.apache.flex.binding.PropertyWatcher, org.apache.flex.binding.WatcherBase);


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.PropertyWatcher.prototype.source;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.PropertyWatcher.prototype.propertyName;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.PropertyWatcher.prototype.eventNames;


/**
 * @export
 * @type {Function}
 */
org.apache.flex.binding.PropertyWatcher.prototype.getterFunction;


/**
 *  The event handler that gets called when
 *  the change events are dispatched.
 *  
 *  @asparam event The event that was dispatched to notify of a value change.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.binding.PropertyWatcher.prototype.changeHandler = function(event) {
  if (org.apache.flex.utils.Language.is(event, org.apache.flex.events.ValueChangeEvent)) {
    var /** @type {string} */ propName = org.apache.flex.utils.Language.as(event, org.apache.flex.events.ValueChangeEvent, true).propertyName;
    if (propName != this.propertyName)
      return;
  }
  this.wrapUpdate(org.apache.flex.utils.Language.closure(this.updateProperty, this, 'updateProperty'));
  this.notifyListeners();
};


/**
 *  @asprivate
 * @export
 * @override
 */
org.apache.flex.binding.PropertyWatcher.prototype.parentChanged = function(parent) {
  if (this.source && org.apache.flex.utils.Language.is(this.source, org.apache.flex.events.IEventDispatcher))
    this.removeEventListeners();
  if (org.apache.flex.utils.Language.is(parent, org.apache.flex.binding.PropertyWatcher))
    this.source = org.apache.flex.utils.Language.as(parent, org.apache.flex.binding.PropertyWatcher, true).value;
  else
    this.source = parent;
  if (this.source && org.apache.flex.utils.Language.is(this.source, org.apache.flex.events.IEventDispatcher))
    this.addEventListeners();
  this.wrapUpdate(org.apache.flex.utils.Language.closure(this.updateProperty, this, 'updateProperty'));
  this.notifyListeners();
};


/**
 * @private
 */
org.apache.flex.binding.PropertyWatcher.prototype.addEventListeners = function() {
  if (org.apache.flex.utils.Language.is(this.eventNames, String))
    this.source.addEventListener(org.apache.flex.utils.Language.as(this.eventNames, String), org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler')); else if (org.apache.flex.utils.Language.is(this.eventNames, Array)) {
    var /** @type {Array} */ arr = org.apache.flex.utils.Language.as(this.eventNames, Array);
    var /** @type {number} */ n = arr.length;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {string} */ eventName = org.apache.flex.utils.Language.string(this.eventNames[i]);
      this.source.addEventListener(eventName, org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
    }
  }
};


/**
 * @private
 */
org.apache.flex.binding.PropertyWatcher.prototype.removeEventListeners = function() {
  if (org.apache.flex.utils.Language.is(this.eventNames, String))
    this.source.removeEventListener(org.apache.flex.utils.Language.as(this.eventNames, String), org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler')); else if (org.apache.flex.utils.Language.is(this.eventNames, Array)) {
    var /** @type {Array} */ arr = org.apache.flex.utils.Language.as(this.eventNames, Array);
    var /** @type {number} */ n = arr.length;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {string} */ eventName = org.apache.flex.utils.Language.string(this.eventNames[i]);
      this.source.removeEventListener(eventName, org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
    }
  }
};


/**
 *  Gets the actual property then updates
 *  the Watcher's children appropriately.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @private
 */
org.apache.flex.binding.PropertyWatcher.prototype.updateProperty = function() {
  if (this.source) {
    if (this.propertyName == "this") {
      this.value = this.source;
    } else {
      if (this.getterFunction != null) {
        this.value = this.getterFunction.apply(this.source, [this.propertyName]);
      } else {
        this.value = this.source[this.propertyName];
      }
    }
  } else {
    this.value = null;
  }
  this.updateChildren();
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.PropertyWatcher.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PropertyWatcher', qName: 'org.apache.flex.binding.PropertyWatcher'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.PropertyWatcher', org.apache.flex.binding.PropertyWatcher);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.PropertyWatcher.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'source': { type: 'Object'},
        'propertyName': { type: 'String'},
        'eventNames': { type: 'Object'},
        'getterFunction': { type: 'Function'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'PropertyWatcher': { type: '', declaredBy: 'org.apache.flex.binding.PropertyWatcher'},
        'parentChanged': { type: 'void', declaredBy: 'org.apache.flex.binding.PropertyWatcher'}
      };
    }
  };
};