/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/binding/ConstantBinding.as
 * org.apache.flex.binding.ConstantBinding
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.binding.ConstantBinding');

goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.binding.ConstantBinding = function() {
};


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.binding.ConstantBinding.prototype.source;


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.binding.ConstantBinding.prototype.document;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.ConstantBinding.prototype.destination;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.ConstantBinding.prototype.sourceID;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.ConstantBinding.prototype.sourcePropertyName;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.ConstantBinding.prototype.destinationPropertyName;


/**
 *  @copy org.apache.flex.core.IDocument#setDocument()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.binding.ConstantBinding.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


Object.defineProperties(org.apache.flex.binding.ConstantBinding.prototype, /** @lends {org.apache.flex.binding.ConstantBinding.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.binding.ConstantBinding} */ function(value) {
  if (this.destination == null)
    this.destination = value;
  if (this.sourceID != null)
    this.source = this.document[this.sourceID];
  else
    this.source = this.document;
  var /** @type {*} */ val;
  if (this.sourcePropertyName in this.source) {
    try {
      val = this.source[this.sourcePropertyName];
      this.destination[this.destinationPropertyName] = val;
    } catch (e) {
    }
  } else if (this.sourcePropertyName in this.source.constructor) {
    try {
      val = this.source.constructor[this.sourcePropertyName];
      this.destination[this.destinationPropertyName] = val;
    } catch (e2) {
    }
  } else {
    var /** @type {Object} */ cname = this.source.FLEXJS_CLASS_INFO;
    if (cname) {
      cname = cname.names[0].qName;
      var /** @type {Array} */ parts = cname.split('.');
      var /** @type {number} */ n = parts.length;
      var /** @type {Object} */ o = window;
      for (var /** @type {number} */ i = 0; i < n; i++) {
        o = o[parts[i]];
      }
      val = o[this.sourcePropertyName];
      this.destination[this.destinationPropertyName] = val;
    }
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.ConstantBinding.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ConstantBinding', qName: 'org.apache.flex.binding.ConstantBinding'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.ConstantBinding', org.apache.flex.binding.ConstantBinding);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.ConstantBinding.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'destination': { type: 'Object'},
        'sourceID': { type: 'String'},
        'sourcePropertyName': { type: 'String'},
        'destinationPropertyName': { type: 'String'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.binding.ConstantBinding'}
      };
    },
    methods: function () {
      return {
        'ConstantBinding': { type: '', declaredBy: 'org.apache.flex.binding.ConstantBinding'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.binding.ConstantBinding'}
      };
    }
  };
};