/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/Path.as
 * org.apache.flex.svg.Path
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.Path');

goog.require('org.apache.flex.svg.GraphicShape');
goog.require('org.apache.flex.graphics.IPath');



/**
 * @constructor
 * @extends {org.apache.flex.svg.GraphicShape}
 * @implements {org.apache.flex.graphics.IPath}
 */
org.apache.flex.svg.Path = function() {
  org.apache.flex.svg.Path.base(this, 'constructor');
};
goog.inherits(org.apache.flex.svg.Path, org.apache.flex.svg.GraphicShape);


/**
 * @private
 * @type {string}
 */
org.apache.flex.svg.Path.prototype._data;


/**
 * @private
 * @type {org.apache.flex.graphics.PathBuilder}
 */
org.apache.flex.svg.Path.prototype._pathCommands;


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.svg.Path.prototype._path;


/**
 *  Draw the path.
 *  @asparam data A PathBuilder object containing a vector of drawing commands.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} xp
 * @param {number} yp
 * @param {org.apache.flex.graphics.PathBuilder} data
 */
org.apache.flex.svg.Path.prototype.drawPathCommands = function(xp, yp, data) {
  this.drawStringPath(xp, yp, data.getPathString());
};


/**
 *  Draw the path.
 *  @asparam data A string containing a compact represention of the path segments.
 *  The value is a space-delimited string describing each path segment. Each
 *  segment entry has a single character which denotes the segment type and
 *  two or more segment parameters.
 *
 *  If the segment command is upper-case, the parameters are absolute values.
 *  If the segment command is lower-case, the parameters are relative values.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} xp
 * @param {number} yp
 * @param {string} data
 */
org.apache.flex.svg.Path.prototype.drawStringPath = function(xp, yp, data) {
  
  if (data == null || data.length === 0)
    return;
  var /** @type {string} */ style = this.getStyleStr();
  if (this._path == null) {
    this._path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    this._path.flexjs_wrapper = this;
    this.element.appendChild(this._path);
  }
  this._path.setAttribute('style', style);
  this._path.setAttribute('d', data);
  this.resize(this.x, this.y, this._path['getBBox']());
};


/**
 * @protected
 * @override
 */
org.apache.flex.svg.Path.prototype.draw = function() {
  this.drawStringPath(0, 0, this.data);
};


Object.defineProperties(org.apache.flex.svg.Path.prototype, /** @lends {org.apache.flex.svg.Path.prototype} */ {
/** @export */
data: {
get: /** @this {org.apache.flex.svg.Path} */ function() {
  return this._data;
},
set: /** @this {org.apache.flex.svg.Path} */ function(value) {
  this._data = value;
  this._pathCommands = null;
}},
/** @export */
pathCommands: {
get: /** @this {org.apache.flex.svg.Path} */ function() {
  return this._pathCommands;
},
set: /** @this {org.apache.flex.svg.Path} */ function(value) {
  this._pathCommands = value;
  this._data = this._pathCommands.getPathString();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.Path.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Path', qName: 'org.apache.flex.svg.Path'}], interfaces: [org.apache.flex.graphics.IPath] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.Path', org.apache.flex.svg.Path);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.Path.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'data': { type: 'String', declaredBy: 'org.apache.flex.svg.Path'},
        'pathCommands': { type: 'PathBuilder', declaredBy: 'org.apache.flex.svg.Path'}
      };
    },
    methods: function () {
      return {
        'drawPathCommands': { type: 'void', declaredBy: 'org.apache.flex.svg.Path'},
        'drawStringPath': { type: 'void', declaredBy: 'org.apache.flex.svg.Path'}
      };
    }
  };
};