/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/LinearGradient.as
 * org.apache.flex.svg.LinearGradient
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.LinearGradient');

goog.require('org.apache.flex.graphics.GradientBase');
goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.graphics.IFill');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.graphics.GradientBase}
 * @implements {org.apache.flex.graphics.IFill}
 */
org.apache.flex.svg.LinearGradient = function() {
  org.apache.flex.svg.LinearGradient.base(this, 'constructor');
};
goog.inherits(org.apache.flex.svg.LinearGradient, org.apache.flex.graphics.GradientBase);


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.LinearGradient.prototype._scaleX;


/**
 * addFillAttrib()
 *
 * @asparam value The IGraphicShape object on which the fill must be added.
 * @asreturn {string}
 * @flexjsignorecoercion Node
 * @export
 * @param {org.apache.flex.graphics.IGraphicShape} value
 * @return {string}
 */
org.apache.flex.svg.LinearGradient.prototype.addFillAttrib = function(value) {
  var /** @type {string} */ svgNS = value.element.namespaceURI;
  var /** @type {HTMLElement} */ grad = org.apache.flex.utils.Language.as(document.createElementNS(svgNS, 'linearGradient'), HTMLElement);
  var /** @type {string} */ gradientId = this.newId;
  grad.setAttribute('id', gradientId);
  grad.setAttribute('x1', '0%');
  grad.setAttribute('y1', '0%');
  grad.setAttribute('x2', '100%');
  grad.setAttribute('y2', '0%');
  if (this.rotation) {
    grad.setAttribute('gradientTransform', 'rotate(' + this.rotation + ' 0.5 0.5)');
  }
  var /** @type {Array} */ entries = this.entries;
  for (var /** @type {number} */ i = 0; i < entries.length; i++) {
    var /** @type {org.apache.flex.graphics.GradientEntry} */ gradientEntry = entries[i];
    var /** @type {HTMLElement} */ stop = org.apache.flex.utils.Language.as(document.createElementNS(svgNS, 'stop'), HTMLElement);
    stop.setAttribute('offset', "" + (gradientEntry.ratio * 100) + '%');
    org.apache.flex.utils.CSSUtils.attributeFromColor(gradientEntry.color);
    stop.setAttribute('stop-color', org.apache.flex.utils.CSSUtils.attributeFromColor(gradientEntry.color));
    stop.setAttribute('stop-opacity', gradientEntry.alpha);
    grad.appendChild(stop);
  }
  var /** @type {Node} */ defs = value.element.querySelector('defs') || value.element.insertBefore(document.createElementNS(svgNS, 'defs'), value.element.firstChild);
  defs.appendChild(grad);
  return 'fill:url(#' + gradientId + ')';
};


Object.defineProperties(org.apache.flex.svg.LinearGradient.prototype, /** @lends {org.apache.flex.svg.LinearGradient.prototype} */ {
/** @export */
scaleX: {
get: /** @this {org.apache.flex.svg.LinearGradient} */ function() {
  return this._scaleX;
},
set: /** @this {org.apache.flex.svg.LinearGradient} */ function(value) {
  this._scaleX = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.LinearGradient.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LinearGradient', qName: 'org.apache.flex.svg.LinearGradient'}], interfaces: [org.apache.flex.graphics.IFill] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.LinearGradient', org.apache.flex.svg.LinearGradient);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.LinearGradient.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'scaleX': { type: 'Number', declaredBy: 'org.apache.flex.svg.LinearGradient'}
      };
    },
    methods: function () {
      return {
        'addFillAttrib': { type: 'String', declaredBy: 'org.apache.flex.svg.LinearGradient'}
      };
    }
  };
};