/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/GraphicShape.as
 * org.apache.flex.svg.GraphicShape
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.GraphicShape');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.graphics.IGraphicShape');



/**
 * Constructor
 *
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.graphics.IGraphicShape}
 */
org.apache.flex.svg.GraphicShape = function() {
  org.apache.flex.svg.GraphicShape.base(this, 'constructor');
};
goog.inherits(org.apache.flex.svg.GraphicShape, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.svg.GraphicShape.prototype._fill;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.svg.GraphicShape.prototype._stroke;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.svg.GraphicShape.prototype.createElement = function() {
  this.element = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
  this.element.flexjs_wrapper = this;
  this.element.style.left = 0;
  this.element.style.top = 0;
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  return this.element;
};


/**
 * This is where the drawing methods get called from
 * @protected
 */
org.apache.flex.svg.GraphicShape.prototype.draw = function() {
};


/**
 * @export
 * @override
 */
org.apache.flex.svg.GraphicShape.prototype.addedToParent = function() {
  
  this.draw();
  this.element.style.overflow = 'visible';
};


/**
 * @asreturn {string} The style attribute.
 * @export
 * @return {string}
 */
org.apache.flex.svg.GraphicShape.prototype.getStyleStr = function() {
  var /** @type {string} */ fillStr;
  if (this.fill) {
    fillStr = this.fill.addFillAttrib(this);
  } else {
    fillStr = 'fill:none';
  }
  var /** @type {string} */ strokeStr;
  if (this.stroke) {
    strokeStr = this.stroke.addStrokeAttrib(this);
  } else {
    strokeStr = 'stroke:none';
  }
  return fillStr + ';' + strokeStr;
};


/**
 * @asparam x X position.
 * @asparam y Y position.
 * @asparam bbox The bounding box of the svg element.
 * @export
 * @param {number} x
 * @param {number} y
 * @param {SVGRect} bbox
 */
org.apache.flex.svg.GraphicShape.prototype.resize = function(x, y, bbox) {
  var /** @type {number} */ useWidth = Math.max(this.width, bbox.width);
  var /** @type {number} */ useHeight = Math.max(this.height, bbox.height);
  this.element.style.position = 'absolute';
  if (!isNaN(x))
    this.element.style.top = x;
  if (!isNaN(y))
    this.element.style.left = y;
  this.element.style.width = useWidth;
  this.element.style.height = useHeight;
  this.element.style.left = x;
  this.element.style.top = y;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.GraphicShape.prototype._x;


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.GraphicShape.prototype._y;


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.GraphicShape.prototype._xOffset;


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.GraphicShape.prototype._yOffset;


/**
 * @asparam x X position.
 * @asparam y Y position.
 * @asparam xOffset offset from x position.
 * @asparam yOffset offset from y position.
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} xOffset
 * @param {number} yOffset
 */
org.apache.flex.svg.GraphicShape.prototype.setPosition = function(x, y, xOffset, yOffset) {
  this._x = x;
  this._y = y;
  this._xOffset = xOffset;
  this._yOffset = yOffset;
  this.element.style.left = xOffset;
  this.element.style.top = yOffset;
};


Object.defineProperties(org.apache.flex.svg.GraphicShape.prototype, /** @lends {org.apache.flex.svg.GraphicShape.prototype} */ {
/** @export */
stroke: {
get: /** @this {org.apache.flex.svg.GraphicShape} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.svg.GraphicShape} */ function(value) {
  this._stroke = value;
}},
/** @export */
fill: {
get: /** @this {org.apache.flex.svg.GraphicShape} */ function() {
  return this._fill;
},
set: /** @this {org.apache.flex.svg.GraphicShape} */ function(value) {
  this._fill = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.GraphicShape.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GraphicShape', qName: 'org.apache.flex.svg.GraphicShape'}], interfaces: [org.apache.flex.graphics.IGraphicShape] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.GraphicShape', org.apache.flex.svg.GraphicShape);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.GraphicShape.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.svg.GraphicShape'},
        'fill': { type: 'IFill', declaredBy: 'org.apache.flex.svg.GraphicShape'}
      };
    },
    methods: function () {
      return {
        'GraphicShape': { type: '', declaredBy: 'org.apache.flex.svg.GraphicShape'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicShape'},
        'getStyleStr': { type: 'String', declaredBy: 'org.apache.flex.svg.GraphicShape'},
        'resize': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicShape'},
        'setPosition': { type: 'void', declaredBy: 'org.apache.flex.svg.GraphicShape'}
      };
    }
  };
};