/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/net/URLBinaryLoader.as
 * org.apache.flex.net.URLBinaryLoader
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.net.URLBinaryLoader');

goog.require('org.apache.flex.events.DetailEvent');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.ProgressEvent');
goog.require('org.apache.flex.net.HTTPConstants');
goog.require('org.apache.flex.net.URLLoader');
goog.require('org.apache.flex.net.URLStream');
goog.require('org.apache.flex.utils.Endian');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.net.URLLoader}
 */
org.apache.flex.net.URLBinaryLoader = function() {
  
  this.endian = org.apache.flex.utils.Endian.BIG_ENDIAN;
  org.apache.flex.net.URLBinaryLoader.base(this, 'constructor');
  this.stream = new org.apache.flex.net.URLStream();
};
goog.inherits(org.apache.flex.net.URLBinaryLoader, org.apache.flex.net.URLLoader);


/**
 * @export
 * @type {org.apache.flex.utils.BinaryData}
 */
org.apache.flex.net.URLBinaryLoader.prototype.data;


/**
 * @export
 * @type {string}
 */
org.apache.flex.net.URLBinaryLoader.prototype.endian;


/**
 * @private
 * @type {org.apache.flex.net.URLStream}
 */
org.apache.flex.net.URLBinaryLoader.prototype.stream;


/**
 * @export
 * @type {number}
 */
org.apache.flex.net.URLBinaryLoader.prototype.bytesLoaded = 0;


/**
 * @export
 * @type {number}
 */
org.apache.flex.net.URLBinaryLoader.prototype.bytesTotal = 0;


/**
 * @private
 * @param {org.apache.flex.net.URLStream} stream
 */
org.apache.flex.net.URLBinaryLoader.prototype.progressFunction = function(stream) {
  this.bytesLoaded = stream.bytesLoaded;
  this.bytesTotal = stream.bytesTotal;
  this.dispatchEvent(new org.apache.flex.events.ProgressEvent(org.apache.flex.events.ProgressEvent.PROGRESS, false, false, this.bytesLoaded, this.bytesTotal));
  if (this.onProgress)
    this.onProgress(this);
};


/**
 * @private
 * @param {org.apache.flex.net.URLStream} stream
 */
org.apache.flex.net.URLBinaryLoader.prototype.statusFunction = function(stream) {
  this.requestStatus = stream.requestStatus;
  this.dispatchEvent(new org.apache.flex.events.DetailEvent(org.apache.flex.net.HTTPConstants.STATUS, false, false, "" + this.requestStatus));
  if (this.onStatus)
    this.onStatus(this);
};


/**
 * @private
 * @param {org.apache.flex.net.URLStream} stream
 */
org.apache.flex.net.URLBinaryLoader.prototype.errorFunction = function(stream) {
  this.dispatchEvent(new org.apache.flex.events.DetailEvent(org.apache.flex.net.HTTPConstants.COMMUNICATION_ERROR, false, false, "" + this.requestStatus));
  if (this.onError)
    this.onError(this);
  this.cleanupCallbacks();
};


/**
 * @private
 * @param {org.apache.flex.net.URLStream} stream
 */
org.apache.flex.net.URLBinaryLoader.prototype.completeFunction = function(stream) {
  this.data = stream.response;
  this.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.net.HTTPConstants.COMPLETE));
  if (this.onComplete)
    this.onComplete(this);
  this.cleanupCallbacks();
};


/**
 * @private
 */
org.apache.flex.net.URLBinaryLoader.prototype.setupCallbacks = function() {
  this.stream.onProgress = org.apache.flex.utils.Language.closure(this.progressFunction, this, 'progressFunction');
  this.stream.onStatus = org.apache.flex.utils.Language.closure(this.statusFunction, this, 'statusFunction');
  this.stream.onError = org.apache.flex.utils.Language.closure(this.errorFunction, this, 'errorFunction');
  this.stream.onComplete = org.apache.flex.utils.Language.closure(this.completeFunction, this, 'completeFunction');
};


/**
 *  Makes the URL request.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 * @param {org.apache.flex.net.URLRequest} request
 */
org.apache.flex.net.URLBinaryLoader.prototype.load = function(request) {
  this.setupCallbacks();
  this.stream.load(request);
};


/**
 *  Cancels the URL request
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7.0
 * @export
 */
org.apache.flex.net.URLBinaryLoader.prototype.close = function() {
  this.stream.close();
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.net.URLBinaryLoader.prototype.completeHandler = function(event) {
  this.data = this.stream.response;
  if (this.data) {
    this.dispatchEvent(event);
    if (this.onComplete)
      this.onComplete(this);
  } else {
    this.dispatchEvent(new org.apache.flex.events.Event(org.apache.flex.net.HTTPConstants.IO_ERROR));
    if (this.onError)
      this.onError(this);
  }
  this.cleanupCallbacks();
};


/**
 * @private
 * @param {org.apache.flex.events.ProgressEvent} event
 */
org.apache.flex.net.URLBinaryLoader.prototype.progressHandler = function(event) {
  this.bytesLoaded = event.current;
  this.bytesTotal = event.total;
  this.dispatchEvent(event);
  if (this.onProgress)
    this.onProgress(this);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.net.URLBinaryLoader.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'URLBinaryLoader', qName: 'org.apache.flex.net.URLBinaryLoader'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.net.URLBinaryLoader', org.apache.flex.net.URLBinaryLoader);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.net.URLBinaryLoader.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'data': { type: 'BinaryData'},
        'endian': { type: 'String'},
        'bytesLoaded': { type: 'uint'},
        'bytesTotal': { type: 'uint'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'URLBinaryLoader': { type: '', declaredBy: 'org.apache.flex.net.URLBinaryLoader'},
        'load': { type: 'void', declaredBy: 'org.apache.flex.net.URLBinaryLoader'},
        'close': { type: 'void', declaredBy: 'org.apache.flex.net.URLBinaryLoader'}
      };
    }
  };
};