/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/chrome/NavigationBar.as
 * org.apache.flex.mobile.chrome.NavigationBar
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.chrome.NavigationBar');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.Container');
goog.require('org.apache.flex.core.IChrome');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.Container}
 * @implements {org.apache.flex.core.IChrome}
 */
org.apache.flex.mobile.chrome.NavigationBar = function() {
  org.apache.flex.mobile.chrome.NavigationBar.base(this, 'constructor');
  this.className = "NavigationBar";
};
goog.inherits(org.apache.flex.mobile.chrome.NavigationBar, org.apache.flex.html.Container);


/**
 * @export
 * @param {boolean} value
 */
org.apache.flex.mobile.chrome.NavigationBar.prototype.hidesBackButton = function(value) {
};


/**
 * @private
 * @type {Array}
 */
org.apache.flex.mobile.chrome.NavigationBar.prototype._controls;


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.mobile.chrome.NavigationBar.prototype.addedToParent = function() {
  org.apache.flex.mobile.chrome.NavigationBar.base(this, 'addedToParent');
  for (var /** @type {number} */ i = 0; i < this._controls.length; i++) {
    this.addElement(this._controls[i], false);
    var /** @type {org.apache.flex.events.IEventDispatcher} */ ctrl = org.apache.flex.utils.Language.as(this._controls[i], org.apache.flex.events.IEventDispatcher);
    ctrl.addEventListener("show", org.apache.flex.utils.Language.closure(this.handleVisibilityChange, this, 'handleVisibilityChange'));
    ctrl.addEventListener("hide", org.apache.flex.utils.Language.closure(this.handleVisibilityChange, this, 'handleVisibilityChange'));
  }
  this.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.chrome.NavigationBar.prototype.handleVisibilityChange = function(event) {
  this.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
};


Object.defineProperties(org.apache.flex.mobile.chrome.NavigationBar.prototype, /** @lends {org.apache.flex.mobile.chrome.NavigationBar.prototype} */ {
/** @export */
controls: {
get: /** @this {org.apache.flex.mobile.chrome.NavigationBar} */ function() {
  return this._controls;
},
set: /** @this {org.apache.flex.mobile.chrome.NavigationBar} */ function(value) {
  this._controls = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.chrome.NavigationBar.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'NavigationBar', qName: 'org.apache.flex.mobile.chrome.NavigationBar'}], interfaces: [org.apache.flex.core.IChrome] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.chrome.NavigationBar', org.apache.flex.mobile.chrome.NavigationBar);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.chrome.NavigationBar.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'controls': { type: 'Array', declaredBy: 'org.apache.flex.mobile.chrome.NavigationBar'}
      };
    },
    methods: function () {
      return {
        'NavigationBar': { type: '', declaredBy: 'org.apache.flex.mobile.chrome.NavigationBar'},
        'hidesBackButton': { type: 'void', declaredBy: 'org.apache.flex.mobile.chrome.NavigationBar'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.mobile.chrome.NavigationBar'}
      };
    }
  };
};