/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/beads/controllers/ToggleSwitchMouseController.as
 * org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController');

goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.mobile.beads.ToggleSwitchView');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IToggleButtonModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IToggleButtonModel}
 */
org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype.model;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype.jsClickHandler = function(event) {
  var /** @type {boolean} */ oldValue = this.model.selected;
  this.model.selected = !oldValue;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("valueChanged"));
};


Object.defineProperties(org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype, /** @lends {org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController} */ function(value) {
  this._strand = value;
  this.model = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IToggleButtonModel);
  
  var /** @type {org.apache.flex.mobile.beads.ToggleSwitchView} */ viewBead = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IBeadView), org.apache.flex.mobile.beads.ToggleSwitchView);
  goog.events.listen(viewBead.boundingBox.element, goog.events.EventType.CLICK, org.apache.flex.utils.Language.closure(this.jsClickHandler, this, 'jsClickHandler'));
  goog.events.listen(viewBead.actualSwitch.element, goog.events.EventType.CLICK, org.apache.flex.utils.Language.closure(this.jsClickHandler, this, 'jsClickHandler'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ToggleSwitchMouseController', qName: 'org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController'}], interfaces: [org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController', org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController'}
      };
    },
    methods: function () {
      return {
        'ToggleSwitchMouseController': { type: '', declaredBy: 'org.apache.flex.mobile.beads.controllers.ToggleSwitchMouseController'}
      };
    }
  };
};