/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/controllers/SliderMouseController.as
 * org.apache.flex.html.beads.controllers.SliderMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.controllers.SliderMouseController');

goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.Slider');
goog.require('org.apache.flex.html.beads.SliderThumbView');
goog.require('org.apache.flex.html.beads.SliderTrackView');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IRangeModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.html.beads.controllers.SliderMouseController = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IRangeModel}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.rangeModel;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.html.beads.SliderTrackView}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.track;


/**
 * @private
 * @type {org.apache.flex.html.beads.SliderThumbView}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.thumb;


/**
 * @private
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.handleTrackClick = function(event) {
  var /** @type {org.apache.flex.html.Slider} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.html.Slider);
  var /** @type {number} */ xloc = event.clientX;
  var /** @type {number} */ p = Math.min(1, xloc / parseInt(this.track.element.style.width, 10));
  var /** @type {number} */ n = p * (host.maximum - host.minimum) + host.minimum;
  host.value = n;
  this.origin = parseInt(this.thumb.element.style.left, 10);
  this.position = parseInt(this.thumb.element.style.left, 10);
  this.calcValFromMousePosition(event, true);
  host.dispatchEvent(new org.apache.flex.events.Event('valueChange'));
};


/**
 * @private
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.handleThumbDown = function(event) {
  var /** @type {org.apache.flex.html.Slider} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.html.Slider);
  goog.events.listen(host.element, goog.events.EventType.MOUSEUP, org.apache.flex.utils.Language.closure(this.handleThumbUp, this, 'handleThumbUp'), false, this);
  goog.events.listen(host.element, goog.events.EventType.MOUSEMOVE, org.apache.flex.utils.Language.closure(this.handleThumbMove, this, 'handleThumbMove'), false, this);
  this.origin = event.clientX;
  this.position = parseInt(this.thumb.element.style.left, 10);
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.origin;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.position;


/**
 * @private
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.handleThumbUp = function(event) {
  var /** @type {org.apache.flex.html.Slider} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.html.Slider);
  goog.events.unlisten(host.element, goog.events.EventType.MOUSEUP, org.apache.flex.utils.Language.closure(this.handleThumbUp, this, 'handleThumbUp'), false, this);
  goog.events.unlisten(host.element, goog.events.EventType.MOUSEMOVE, org.apache.flex.utils.Language.closure(this.handleThumbMove, this, 'handleThumbMove'), false, this);
  this.calcValFromMousePosition(event, false);
  host.dispatchEvent(new org.apache.flex.events.Event('valueChange'));
};


/**
 * @private
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.handleThumbMove = function(event) {
  var /** @type {org.apache.flex.html.Slider} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.html.Slider);
  this.calcValFromMousePosition(event, false);
  host.dispatchEvent(new org.apache.flex.events.Event('valueChange'));
};


/**
 * @private
 * @param {org.apache.flex.events.BrowserEvent} event
 * @param {boolean} useOffset
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.calcValFromMousePosition = function(event, useOffset) {
  var /** @type {org.apache.flex.html.Slider} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.html.Slider);
  var /** @type {number} */ deltaX = (useOffset ? event.offsetX : event.clientX) - this.origin;
  var /** @type {number} */ thumbW = parseInt(this.thumb.element.style.width, 10) / 2;
  var /** @type {number} */ newX = this.position + deltaX;
  var /** @type {number} */ p = newX / parseInt(this.track.element.style.width, 10);
  var /** @type {number} */ n = p * (host.maximum - host.minimum) + host.minimum;
  n = host.snap(n);
  if (n < host.minimum)
    n = host.minimum;
  else if (n > host.maximum)
    n = host.maximum;
  p = (n - host.minimum) / (host.maximum - host.minimum);
  newX = p * parseInt(this.track.element.style.width, 10);
  this.thumb.element.style.left = String(newX - parseInt(this.thumb.element.style.width, 10) / 2) + 'px';
  host.value = n;
};


Object.defineProperties(org.apache.flex.html.beads.controllers.SliderMouseController.prototype, /** @lends {org.apache.flex.html.beads.controllers.SliderMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.controllers.SliderMouseController} */ function(value) {
  this._strand = value;
  this.rangeModel = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IRangeModel);
  
  this.track = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.SliderTrackView), org.apache.flex.html.beads.SliderTrackView);
  this.thumb = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.SliderThumbView), org.apache.flex.html.beads.SliderThumbView);
  goog.events.listen(this.track.element, goog.events.EventType.CLICK, org.apache.flex.utils.Language.closure(this.handleTrackClick, this, 'handleTrackClick'), false, this);
  goog.events.listen(this.thumb.element, goog.events.EventType.MOUSEDOWN, org.apache.flex.utils.Language.closure(this.handleThumbDown, this, 'handleThumbDown'), false, this);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SliderMouseController', qName: 'org.apache.flex.html.beads.controllers.SliderMouseController'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.controllers.SliderMouseController', org.apache.flex.html.beads.controllers.SliderMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.controllers.SliderMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.controllers.SliderMouseController'}
      };
    },
    methods: function () {
      return {
        'SliderMouseController': { type: '', declaredBy: 'org.apache.flex.html.beads.controllers.SliderMouseController'}
      };
    }
  };
};