/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/WebBrowserView.as
 * org.apache.flex.html.beads.WebBrowserView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.WebBrowserView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.beads.models.WebBrowserModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.WebBrowserView = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.WebBrowserView.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.WebBrowserView.prototype.loadPage = function(event) {
  var /** @type {org.apache.flex.html.beads.models.WebBrowserModel} */ model = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).model, org.apache.flex.html.beads.models.WebBrowserModel);
  var /** @type {HTMLIFrameElement} */ iframe = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).element, HTMLIFrameElement);
  iframe.src = model.url;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.WebBrowserView.prototype.handlePageShow = function(event) {
  var /** @type {org.apache.flex.html.beads.models.WebBrowserModel} */ model = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).model, org.apache.flex.html.beads.models.WebBrowserModel);
  var /** @type {HTMLIFrameElement} */ iframe = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).element, HTMLIFrameElement);
  model.setURL(iframe.src);
  this.host.dispatchEvent(new org.apache.flex.events.Event("locationChanged"));
};


Object.defineProperties(org.apache.flex.html.beads.WebBrowserView.prototype, /** @lends {org.apache.flex.html.beads.WebBrowserView.prototype} */ {
/** @export */
host: {
get: /** @this {org.apache.flex.html.beads.WebBrowserView} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.WebBrowserView} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.events.IEventDispatcher} */ model = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).model, org.apache.flex.events.IEventDispatcher);
  model.addEventListener("urlChanged", org.apache.flex.utils.Language.closure(this.loadPage, this, 'loadPage'));
  var /** @type {HTMLIFrameElement} */ iframe = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).element, HTMLIFrameElement);
  iframe.addEventListener("load", org.apache.flex.utils.Language.closure(this.handlePageShow, this, 'handlePageShow'), false);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.WebBrowserView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'WebBrowserView', qName: 'org.apache.flex.html.beads.WebBrowserView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.WebBrowserView', org.apache.flex.html.beads.WebBrowserView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.WebBrowserView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'host': { type: 'IUIBase', declaredBy: 'org.apache.flex.html.beads.WebBrowserView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.WebBrowserView'}
      };
    },
    methods: function () {
      return {
        'WebBrowserView': { type: '', declaredBy: 'org.apache.flex.html.beads.WebBrowserView'}
      };
    }
  };
};