/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/AlertView.as
 * org.apache.flex.html.beads.AlertView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.AlertView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.Alert');
goog.require('org.apache.flex.html.ControlBar');
goog.require('org.apache.flex.html.Label');
goog.require('org.apache.flex.html.TextButton');
goog.require('org.apache.flex.html.TitleBar');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.core.IAlertModel');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IParent');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IBackgroundBead');
goog.require('org.apache.flex.html.beads.IBorderBead');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.AlertView = function() {
  org.apache.flex.html.beads.AlertView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.AlertView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.html.TitleBar}
 */
org.apache.flex.html.beads.AlertView.prototype._titleBar;


/**
 * @private
 * @type {org.apache.flex.html.ControlBar}
 */
org.apache.flex.html.beads.AlertView.prototype._controlBar;


/**
 * @private
 * @type {org.apache.flex.html.Label}
 */
org.apache.flex.html.beads.AlertView.prototype._label;


/**
 * @private
 * @type {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.beads.AlertView.prototype._okButton;


/**
 * @private
 * @type {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.beads.AlertView.prototype._cancelButton;


/**
 * @private
 * @type {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.beads.AlertView.prototype._yesButton;


/**
 * @private
 * @type {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.beads.AlertView.prototype._noButton;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.AlertView.prototype.sizeHandler = function(event) {
  var /** @type {org.apache.flex.core.IMeasurementBead} */ labelMeasure = this._label.measurementBead;
  var /** @type {org.apache.flex.core.IMeasurementBead} */ titleMeasure = this._titleBar.measurementBead;
  var /** @type {org.apache.flex.core.IMeasurementBead} */ ctrlMeasure = this._controlBar.measurementBead;
  var /** @type {number} */ maxWidth = Math.max(titleMeasure.measuredWidth, ctrlMeasure.measuredWidth, labelMeasure.measuredWidth);
  var /** @type {org.apache.flex.geom.Rectangle} */ metrics = org.apache.flex.utils.CSSContainerUtils.getBorderAndPaddingMetrics(this._strand);
  this._titleBar.x = 0;
  this._titleBar.y = 0;
  this._titleBar.width = maxWidth;
  this._titleBar.height = 25;
  this._titleBar.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
  this._label.x = metrics.left;
  this._label.y = this._titleBar.y + this._titleBar.height + metrics.top;
  this._label.width = maxWidth - metrics.left - metrics.right;
  this._controlBar.x = 0;
  this._controlBar.y = this._titleBar.height + this._label.y + this._label.height + metrics.bottom;
  this._controlBar.width = maxWidth;
  this._controlBar.height = 25;
  this._controlBar.dispatchEvent(new org.apache.flex.events.Event("layoutNeeded"));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).width = maxWidth;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).height = this._titleBar.height + this._label.height + this._controlBar.height + metrics.top + metrics.bottom;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.AlertView.prototype.handleOK = function(event) {
  this.dispatchCloseEvent(org.apache.flex.html.Alert.OK);
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.AlertView.prototype.handleCancel = function(event) {
  this.dispatchCloseEvent(org.apache.flex.html.Alert.CANCEL);
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.AlertView.prototype.handleYes = function(event) {
  this.dispatchCloseEvent(org.apache.flex.html.Alert.YES);
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.AlertView.prototype.handleNo = function(event) {
  this.dispatchCloseEvent(org.apache.flex.html.Alert.NO);
};


/**
 * @asprivate
 * @export
 * @param {number} buttonFlag
 */
org.apache.flex.html.beads.AlertView.prototype.dispatchCloseEvent = function(buttonFlag) {
  var /** @type {org.apache.flex.events.Event} */ newEvent = new org.apache.flex.events.Event("close", true);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(newEvent);
};


Object.defineProperties(org.apache.flex.html.beads.AlertView.prototype, /** @lends {org.apache.flex.html.beads.AlertView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.AlertView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.AlertView, this, 'strand', value);
  var /** @type {Object} */ backgroundColor = org.apache.flex.core.ValuesManager.valuesImpl.getValue(value, "background-color");
  var /** @type {Object} */ backgroundImage = org.apache.flex.core.ValuesManager.valuesImpl.getValue(value, "background-image");
  if (backgroundColor != null || backgroundImage != null) {
    if (value.getBeadByType(org.apache.flex.html.beads.IBackgroundBead) == null)
      value.addBead(org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(value, "iBackgroundBead"))(), org.apache.flex.core.IBead));
  }
  var /** @type {string} */ borderStyle;
  var /** @type {Object} */ borderStyles = org.apache.flex.core.ValuesManager.valuesImpl.getValue(value, "border");
  if (org.apache.flex.utils.Language.is(borderStyles, Array)) {
    borderStyle = org.apache.flex.utils.Language.string(borderStyles[1]);
  }
  if (borderStyle == null) {
    borderStyle = org.apache.flex.utils.Language.as(org.apache.flex.core.ValuesManager.valuesImpl.getValue(value, "border-style"), String);
  }
  if (borderStyle != null && borderStyle != "none") {
    if (value.getBeadByType(org.apache.flex.html.beads.IBorderBead) == null)
      value.addBead(org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(value, "iBorderBead"))(), org.apache.flex.core.IBead));
  }
  var /** @type {number} */ flags = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).flags;
  if (flags & org.apache.flex.html.Alert.OK) {
    this._okButton = new org.apache.flex.html.TextButton();
    this._okButton.text = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).okLabel;
    this._okButton.addEventListener("click", org.apache.flex.utils.Language.closure(this.handleOK, this, 'handleOK'));
  }
  if (flags & org.apache.flex.html.Alert.CANCEL) {
    this._cancelButton = new org.apache.flex.html.TextButton();
    this._cancelButton.text = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).cancelLabel;
    this._cancelButton.addEventListener("click", org.apache.flex.utils.Language.closure(this.handleCancel, this, 'handleCancel'));
  }
  if (flags & org.apache.flex.html.Alert.YES) {
    this._yesButton = new org.apache.flex.html.TextButton();
    this._yesButton.text = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).yesLabel;
    this._yesButton.addEventListener("click", org.apache.flex.utils.Language.closure(this.handleYes, this, 'handleYes'));
  }
  if (flags & org.apache.flex.html.Alert.NO) {
    this._noButton = new org.apache.flex.html.TextButton();
    this._noButton.text = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).noLabel;
    this._noButton.addEventListener("click", org.apache.flex.utils.Language.closure(this.handleNo, this, 'handleNo'));
  }
  this._titleBar = new org.apache.flex.html.TitleBar();
  this._titleBar.title = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).title;
  this._label = new org.apache.flex.html.Label();
  this._label.text = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IAlertModel, true).message;
  this._controlBar = new org.apache.flex.html.ControlBar();
  if (this._okButton)
    this._controlBar.addElement(this._okButton);
  if (this._cancelButton)
    this._controlBar.addElement(this._cancelButton);
  if (this._yesButton)
    this._controlBar.addElement(this._yesButton);
  if (this._noButton)
    this._controlBar.addElement(this._noButton);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IParent, true).addElement(this._titleBar);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IParent, true).addElement(this._controlBar);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IParent, true).addElement(this._label);
  this.sizeHandler(null);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.AlertView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'AlertView', qName: 'org.apache.flex.html.beads.AlertView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.AlertView', org.apache.flex.html.beads.AlertView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.AlertView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.AlertView'}
      };
    },
    methods: function () {
      return {
        'AlertView': { type: '', declaredBy: 'org.apache.flex.html.beads.AlertView'},
        'dispatchCloseEvent': { type: 'void', declaredBy: 'org.apache.flex.html.beads.AlertView'}
      };
    }
  };
};