/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/accessories/DateFormatMMDDYYYYBead.as
 * org.apache.flex.html.accessories.DateFormatMMDDYYYYBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.accessories.DateFormatMMDDYYYYBead');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDateChooserModel');
goog.require('org.apache.flex.core.IFormatBead');
goog.require('org.apache.flex.utils.Language');



/**
 * constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IFormatBead}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead = function() {
  org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.accessories.DateFormatMMDDYYYYBead, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype._propertyName;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype._eventName;


/**
 * @private
 * @type {string}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype._formattedResult;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype._strand;


/**
 * @asprivate
 * 
 * @flexjsignorecoercion org.apache.flex.core.IStrandWithModel
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype.handleTextChange = function(event) {
  var /** @type {org.apache.flex.core.IDateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.model, org.apache.flex.core.IDateChooserModel);
  var /** @type {Date} */ d = model.selectedDate;
  var /** @type {string} */ month = String(d.getMonth() + 1);
  if (Number(month) < 10)
    month = "0" + month;
  var /** @type {string} */ date = String(d.getDate());
  if (Number(date) < 10)
    date = "0" + date;
  var /** @type {string} */ fmt = month + "/" + date + "/" + String(d.getFullYear());
  this._formattedResult = month + "/" + date + "/" + String(d.getFullYear());
  this.dispatchEvent(new org.apache.flex.events.Event("formatChanged"));
};


Object.defineProperties(org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype, /** @lends {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype} */ {
/** @export */
propertyName: {
get: /** @this {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead} */ function() {
  if (this._propertyName == null) {
    return "selectedDate";
  }
  return this._propertyName;
},
set: /** @this {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead} */ function(value) {
  this._propertyName = value;
}},
/** @export */
eventName: {
get: /** @this {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead} */ function() {
  if (this._eventName == null) {
    return this._propertyName + "Changed";
  }
  return this._eventName;
},
set: /** @this {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead} */ function(value) {
  this._eventName = value;
}},
/** @export */
formattedString: {
get: /** @this {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead} */ function() {
  return this._formattedResult;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.accessories.DateFormatMMDDYYYYBead} */ function(value) {
  this._strand = value;
  var /** @type {org.apache.flex.core.IDateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.model, org.apache.flex.core.IDateChooserModel);
  model.addEventListener("selectedDateChanged", org.apache.flex.utils.Language.closure(this.handleTextChange, this, 'handleTextChange'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DateFormatMMDDYYYYBead', qName: 'org.apache.flex.html.accessories.DateFormatMMDDYYYYBead'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IFormatBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.accessories.DateFormatMMDDYYYYBead', org.apache.flex.html.accessories.DateFormatMMDDYYYYBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.accessories.DateFormatMMDDYYYYBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'propertyName': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.DateFormatMMDDYYYYBead'},
        'eventName': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.DateFormatMMDDYYYYBead'},
        'formattedString': { type: 'String', declaredBy: 'org.apache.flex.html.accessories.DateFormatMMDDYYYYBead'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.accessories.DateFormatMMDDYYYYBead'}
      };
    },
    methods: function () {
      return {
        'DateFormatMMDDYYYYBead': { type: '', declaredBy: 'org.apache.flex.html.accessories.DateFormatMMDDYYYYBead'}
      };
    }
  };
};