/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/TextArea.as
 * org.apache.flex.html.TextArea
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.TextArea');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ITextModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.TextArea = function() {
  org.apache.flex.html.TextArea.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.TextArea, org.apache.flex.core.UIBase);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.TextArea.prototype.createElement = function() {
  this.element = document.createElement('textarea');
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this.element.className = 'TextArea';
  this.typeNames = 'TextArea';
  return this.element;
};


Object.defineProperties(org.apache.flex.html.TextArea.prototype, /** @lends {org.apache.flex.html.TextArea.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.html.TextArea} */ function() {
  
  return this.element.value;
},
set: /** @this {org.apache.flex.html.TextArea} */ function(value) {
  
  this.element.value = value;
}},
/** @export */
html: {
get: /** @this {org.apache.flex.html.TextArea} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITextModel, true).html;
},
set: /** @this {org.apache.flex.html.TextArea} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITextModel, true).html = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.TextArea.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TextArea', qName: 'org.apache.flex.html.TextArea'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.TextArea', org.apache.flex.html.TextArea);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.TextArea.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.TextArea'},
        'html': { type: 'String', declaredBy: 'org.apache.flex.html.TextArea'}
      };
    },
    methods: function () {
      return {
        'TextArea': { type: '', declaredBy: 'org.apache.flex.html.TextArea'}
      };
    }
  };
};