/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/Slider.as
 * org.apache.flex.html.Slider
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.Slider');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.SliderThumbView');
goog.require('org.apache.flex.html.beads.SliderTrackView');
goog.require('org.apache.flex.html.beads.controllers.SliderMouseController');
goog.require('org.apache.flex.core.IRangeModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.Slider = function() {
  org.apache.flex.html.Slider.base(this, 'constructor');
  this.className = "Slider";
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).value = 0;
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).minimum = 0;
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).maximum = 100;
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).stepSize = 1;
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).snapInterval = 1;
};
goog.inherits(org.apache.flex.html.Slider, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {org.apache.flex.html.beads.SliderTrackView}
 */
org.apache.flex.html.Slider.prototype.track;


/**
 * @private
 * @type {org.apache.flex.html.beads.SliderThumbView}
 */
org.apache.flex.html.Slider.prototype.thumb;


/**
 * @private
 * @type {org.apache.flex.html.beads.controllers.SliderMouseController}
 */
org.apache.flex.html.Slider.prototype.controller;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.Slider.prototype.createElement = function() {
  this.element = document.createElement('div');
  this.element.style.width = '200px';
  this.element.style.height = '30px';
  this.track = new org.apache.flex.html.beads.SliderTrackView();
  this.addBead(this.track);
  this.thumb = new org.apache.flex.html.beads.SliderThumbView();
  this.addBead(this.thumb);
  this.controller = new org.apache.flex.html.beads.controllers.SliderMouseController();
  this.addBead(this.controller);
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this.className = 'Slider';
  return this.element;
};


/**
 * @export
 * @param {number} value
 * @return {number}
 */
org.apache.flex.html.Slider.prototype.snap = function(value) {
  var /** @type {number} */ si = this.snapInterval;
  var /** @type {number} */ n = Math.round((value - this.minimum) / si) * si + this.minimum;
  if (value > 0) {
    if (value - n < n + si - value)
      return n;
    return n + si;
  }
  if (value - n > n + si - value)
    return n + si;
  return n;
};


/**
 * @asparam {number} value The value used to calculate new position of the thumb.
 * @asreturn {void} Moves the thumb to the corresponding position.
 * @export
 * @param {number} value
 */
org.apache.flex.html.Slider.prototype.setThumbFromValue = function(value) {
  var /** @type {number} */ min = Number(this.model.minimum);
  var /** @type {number} */ max = Number(this.model.maximum);
  var /** @type {number} */ p = (value - min) / (max - min);
  var /** @type {number} */ xloc = p * (parseInt(this.track.element.style.width, 10) - parseInt(this.thumb.element.style.width, 10));
  this.thumb.element.style.left = "" + xloc + 'px';
};


Object.defineProperties(org.apache.flex.html.Slider.prototype, /** @lends {org.apache.flex.html.Slider.prototype} */ {
/** @export */
value: {
get: /** @this {org.apache.flex.html.Slider} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).value;
},
set: /** @this {org.apache.flex.html.Slider} */ function(newValue) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).value = newValue;
}},
/** @export */
minimum: {
get: /** @this {org.apache.flex.html.Slider} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).minimum;
},
set: /** @this {org.apache.flex.html.Slider} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).minimum = value;
}},
/** @export */
maximum: {
get: /** @this {org.apache.flex.html.Slider} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).maximum;
},
set: /** @this {org.apache.flex.html.Slider} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).maximum = value;
}},
/** @export */
snapInterval: {
get: /** @this {org.apache.flex.html.Slider} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).snapInterval;
},
set: /** @this {org.apache.flex.html.Slider} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).snapInterval = value;
}},
/** @export */
stepSize: {
get: /** @this {org.apache.flex.html.Slider} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).stepSize;
},
set: /** @this {org.apache.flex.html.Slider} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.IRangeModel, true).stepSize = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.Slider.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Slider', qName: 'org.apache.flex.html.Slider'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.Slider', org.apache.flex.html.Slider);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.Slider.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'value': { type: 'Number', declaredBy: 'org.apache.flex.html.Slider'},
        'minimum': { type: 'Number', declaredBy: 'org.apache.flex.html.Slider'},
        'maximum': { type: 'Number', declaredBy: 'org.apache.flex.html.Slider'},
        'snapInterval': { type: 'Number', declaredBy: 'org.apache.flex.html.Slider'},
        'stepSize': { type: 'Number', declaredBy: 'org.apache.flex.html.Slider'}
      };
    },
    methods: function () {
      return {
        'Slider': { type: '', declaredBy: 'org.apache.flex.html.Slider'},
        'snap': { type: 'Number', declaredBy: 'org.apache.flex.html.Slider'},
        'setThumbFromValue': { type: 'void', declaredBy: 'org.apache.flex.html.Slider'}
      };
    },
    metadata: function () { return [ ]; }
  };
};