/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/MoveTo.as
 * org.apache.flex.graphics.MoveTo
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.MoveTo');

goog.require('org.apache.flex.graphics.IPathCommand');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.graphics.IPathCommand}
 * @param {number} x
 * @param {number} y
 */
org.apache.flex.graphics.MoveTo = function(x, y) {
  this._x = x;
  this._y = y;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.MoveTo.prototype._x;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.MoveTo.prototype._y;


/**
 * @export
 * @return {string}
 */
org.apache.flex.graphics.MoveTo.prototype.toString = function() {
  return ["M", this._x, this._y].join(" ");
};


/**
 * @export
 * @param {Object} ctx
 */
org.apache.flex.graphics.MoveTo.prototype.execute = function(ctx) {
  ctx.moveTo(this._x, this._y);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.MoveTo.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'MoveTo', qName: 'org.apache.flex.graphics.MoveTo'}], interfaces: [org.apache.flex.graphics.IPathCommand] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.MoveTo', org.apache.flex.graphics.MoveTo);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.MoveTo.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'MoveTo': { type: '', declaredBy: 'org.apache.flex.graphics.MoveTo'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.graphics.MoveTo'},
        'execute': { type: 'void', declaredBy: 'org.apache.flex.graphics.MoveTo'}
      };
    }
  };
};