/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/geom/Rectangle.as
 * org.apache.flex.geom.Rectangle
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.geom.Rectangle');

goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {number=} x
 * @param {number=} y
 * @param {number=} width
 * @param {number=} height
 */
org.apache.flex.geom.Rectangle = function(x, y, width, height) {
  x = typeof x !== 'undefined' ? x : 0;
  y = typeof y !== 'undefined' ? y : 0;
  width = typeof width !== 'undefined' ? width : 0;
  height = typeof height !== 'undefined' ? height : 0;
  this.x = x;
  this.y = y;
  this.width = width;
  this.height = height;
};


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Rectangle.prototype.x;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Rectangle.prototype.y;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Rectangle.prototype.width;


/**
 * @export
 * @type {number}
 */
org.apache.flex.geom.Rectangle.prototype.height;


/**
 * @export
 * @return {org.apache.flex.geom.Rectangle}
 */
org.apache.flex.geom.Rectangle.prototype.clone = function() {
  return new org.apache.flex.geom.Rectangle(this.x, this.y, this.width, this.height);
};


/**
 * @export
 * @return {boolean}
 */
org.apache.flex.geom.Rectangle.prototype.isEmpty = function() {
  return this.width <= 0 || this.height <= 0;
};


/**
 * @export
 */
org.apache.flex.geom.Rectangle.prototype.setEmpty = function() {
  this.x = 0;
  this.y = 0;
  this.width = 0;
  this.height = 0;
};


/**
 * @export
 * @param {number} dx
 * @param {number} dy
 */
org.apache.flex.geom.Rectangle.prototype.inflate = function(dx, dy) {
  this.x = this.x - dx;
  this.width = this.width + 2 * dx;
  this.y = this.y - dy;
  this.height = this.height + 2 * dy;
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} point
 */
org.apache.flex.geom.Rectangle.prototype.inflatePoint = function(point) {
  this.x = this.x - point.x;
  this.width = this.width + 2 * point.x;
  this.y = this.y - point.y;
  this.height = this.height + 2 * point.y;
};


/**
 * @export
 * @param {number} dx
 * @param {number} dy
 */
org.apache.flex.geom.Rectangle.prototype.offset = function(dx, dy) {
  this.x = this.x + dx;
  this.y = this.y + dy;
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} point
 */
org.apache.flex.geom.Rectangle.prototype.offsetPoint = function(point) {
  this.x = this.x + point.x;
  this.y = this.y + point.y;
};


/**
 * @export
 * @param {number} x
 * @param {number} y
 * @return {boolean}
 */
org.apache.flex.geom.Rectangle.prototype.contains = function(x, y) {
  return x >= x && x < x + this.width && y >= y && y < y + this.height;
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} point
 * @return {boolean}
 */
org.apache.flex.geom.Rectangle.prototype.containsPoint = function(point) {
  return point.x >= this.x && point.x < this.x + this.width && point.y >= this.y && point.y < this.y + this.height;
};


/**
 * @export
 * @param {org.apache.flex.geom.Rectangle} rect
 * @return {boolean}
 */
org.apache.flex.geom.Rectangle.prototype.containsRect = function(rect) {
  var /** @type {number} */ r1 = rect.x + rect.width;
  var /** @type {number} */ b1 = rect.y + rect.height;
  var /** @type {number} */ r2 = this.x + this.width;
  var /** @type {number} */ b2 = this.y + this.height;
  return rect.x >= this.x && rect.x < r2 && rect.y >= this.y && rect.y < b2 && r1 > this.x && r1 <= r2 && b1 > this.y && b1 <= b2;
};


/**
 * @export
 * @param {org.apache.flex.geom.Rectangle} toIntersect
 * @return {org.apache.flex.geom.Rectangle}
 */
org.apache.flex.geom.Rectangle.prototype.intersection = function(toIntersect) {
  var /** @type {org.apache.flex.geom.Rectangle} */ result = new org.apache.flex.geom.Rectangle();
  if (this.isEmpty() || toIntersect.isEmpty()) {
    result.setEmpty();
    return result;
  }
  result.x = Math.max(this.x, toIntersect.x);
  result.y = Math.max(this.y, toIntersect.y);
  result.width = Math.min(this.x + this.width, toIntersect.x + toIntersect.width) - result.x;
  result.height = Math.min(this.y + this.height, toIntersect.y + toIntersect.height) - result.y;
  if (result.width <= 0 || result.height <= 0) {
    result.setEmpty();
  }
  return result;
};


/**
 * @export
 * @param {org.apache.flex.geom.Rectangle} toIntersect
 * @return {boolean}
 */
org.apache.flex.geom.Rectangle.prototype.intersects = function(toIntersect) {
  if (this.isEmpty() || toIntersect.isEmpty()) {
    return false;
  }
  var /** @type {number} */ resultx = Math.max(this.x, toIntersect.x);
  var /** @type {number} */ resulty = Math.max(this.y, toIntersect.y);
  var /** @type {number} */ resultwidth = Math.min(this.x + this.width, toIntersect.x + toIntersect.width) - resultx;
  var /** @type {number} */ resultheight = Math.min(this.y + this.height, toIntersect.y + toIntersect.height) - resulty;
  if (resultwidth <= 0 || resultheight <= 0) {
    return false;
  }
  return true;
};


/**
 * @export
 * @param {org.apache.flex.geom.Rectangle} toUnion
 * @return {org.apache.flex.geom.Rectangle}
 */
org.apache.flex.geom.Rectangle.prototype.union = function(toUnion) {
  var /** @type {org.apache.flex.geom.Rectangle} */ r = null;
  if (this.isEmpty()) {
    return toUnion.clone();
  }
  if (toUnion.isEmpty()) {
    return this.clone();
  }
  r = new org.apache.flex.geom.Rectangle();
  r.x = Math.min(this.x, toUnion.x);
  r.y = Math.min(this.y, toUnion.y);
  r.width = Math.max(this.x + this.width, toUnion.x + toUnion.width) - r.x;
  r.height = Math.max(this.y + this.height, toUnion.y + toUnion.height) - r.y;
  return r;
};


/**
 * @export
 * @param {org.apache.flex.geom.Rectangle} toCompare
 * @return {boolean}
 */
org.apache.flex.geom.Rectangle.prototype.equals = function(toCompare) {
  return toCompare.x == this.x && toCompare.y == this.y && toCompare.width == this.width && toCompare.height == this.height;
};


/**
 * @export
 * @return {string}
 */
org.apache.flex.geom.Rectangle.prototype.toString = function() {
  return "(x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height + ")";
};


/**
 * @export
 * @param {org.apache.flex.geom.Rectangle} sourceRect
 */
org.apache.flex.geom.Rectangle.prototype.copyFrom = function(sourceRect) {
  this.x = sourceRect.x;
  this.y = sourceRect.y;
  this.width = sourceRect.width;
  this.height = sourceRect.height;
};


/**
 * @export
 * @param {number} xa
 * @param {number} ya
 * @param {number} widtha
 * @param {number} heighta
 */
org.apache.flex.geom.Rectangle.prototype.setTo = function(xa, ya, widtha, heighta) {
  this.x = xa;
  this.y = ya;
  this.width = widtha;
  this.height = heighta;
};


Object.defineProperties(org.apache.flex.geom.Rectangle.prototype, /** @lends {org.apache.flex.geom.Rectangle.prototype} */ {
/** @export */
left: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return this.x;
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.x = value;
}},
/** @export */
top: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return this.y;
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.y = value;
}},
/** @export */
right: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return this.x + this.width;
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.width = value - this.x;
}},
/** @export */
bottom: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return this.y + this.height;
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.height = value - this.y;
}},
/** @export */
topLeft: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return new org.apache.flex.geom.Point(this.x, this.y);
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.width = this.width + (this.x - value.x);
  this.height = this.height + (this.y - value.y);
  this.x = value.x;
  this.y = value.y;
}},
/** @export */
bottomRight: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return new org.apache.flex.geom.Point(this.right, this.bottom);
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.width = value.x - this.x;
  this.height = value.y - this.y;
}},
/** @export */
size: {
get: /** @this {org.apache.flex.geom.Rectangle} */ function() {
  return new org.apache.flex.geom.Point(this.width, this.height);
},
set: /** @this {org.apache.flex.geom.Rectangle} */ function(value) {
  this.width = value.x;
  this.height = value.y;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.geom.Rectangle.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Rectangle', qName: 'org.apache.flex.geom.Rectangle'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.geom.Rectangle', org.apache.flex.geom.Rectangle);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.geom.Rectangle.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'x': { type: 'Number'},
        'y': { type: 'Number'},
        'width': { type: 'Number'},
        'height': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
        'left': { type: 'Number', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'top': { type: 'Number', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'right': { type: 'Number', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'bottom': { type: 'Number', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'topLeft': { type: 'Point', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'bottomRight': { type: 'Point', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'size': { type: 'Point', declaredBy: 'org.apache.flex.geom.Rectangle'}
      };
    },
    methods: function () {
      return {
        'Rectangle': { type: '', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'clone': { type: 'Rectangle', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'isEmpty': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'setEmpty': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'inflate': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'inflatePoint': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'offset': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'offsetPoint': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'contains': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'containsPoint': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'containsRect': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'intersection': { type: 'Rectangle', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'intersects': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'union': { type: 'Rectangle', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'equals': { type: 'Boolean', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'copyFrom': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'},
        'setTo': { type: 'void', declaredBy: 'org.apache.flex.geom.Rectangle'}
      };
    }
  };
};