/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/flat/CheckBox.as
 * org.apache.flex.flat.CheckBox
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.flat.CheckBox');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.flat.CheckBox = function() {
  org.apache.flex.flat.CheckBox.base(this, 'constructor');
};
goog.inherits(org.apache.flex.flat.CheckBox, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {HTMLInputElement}
 */
org.apache.flex.flat.CheckBox.prototype.input;


/**
 * @private
 * @type {HTMLSpanElement}
 */
org.apache.flex.flat.CheckBox.prototype.checkbox;


/**
 * @private
 * @type {HTMLLabelElement}
 */
org.apache.flex.flat.CheckBox.prototype.label;


/**
 * @private
 * @type {Text}
 */
org.apache.flex.flat.CheckBox.prototype.textNode;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLLabelElement
 * @flexjsignorecoercion HTMLInputElement
 * @flexjsignorecoercion HTMLSpanElement
 * @flexjsignorecoercion Text
 * @protected
 * @override
 */
org.apache.flex.flat.CheckBox.prototype.createElement = function() {
  this.label = document.createElement('label');
  this.element = this.label;
  this.input = document.createElement('input');
  this.input.type = 'checkbox';
  this.input.className = 'checkbox-input';
  this.input.addEventListener('change', org.apache.flex.utils.Language.closure(this.selectionChangeHandler, this, 'selectionChangeHandler'), false);
  this.label.appendChild(this.input);
  this.checkbox = document.createElement('span');
  this.checkbox.className = 'checkbox-icon';
  this.checkbox.addEventListener('mouseover', org.apache.flex.utils.Language.closure(this.mouseOverHandler, this, 'mouseOverHandler'), false);
  this.checkbox.addEventListener('mouseout', org.apache.flex.utils.Language.closure(this.mouseOutHandler, this, 'mouseOutHandler'), false);
  this.label.appendChild(this.checkbox);
  this.textNode = document.createTextNode('');
  this.label.appendChild(this.textNode);
  this.label.className = 'CheckBox';
  this.typeNames = 'CheckBox';
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.input.flexjs_wrapper = this;
  this.checkbox.flexjs_wrapper = this;
  this.element.flexjs_wrapper = this;
  return this.element;
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.flat.CheckBox.prototype.mouseOverHandler = function(event) {
  this.checkbox.className = 'checkbox-icon-hover';
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.flat.CheckBox.prototype.mouseOutHandler = function(event) {
  if (this.input.checked)
    this.checkbox.className = 'checkbox-icon-checked';
  else
    this.checkbox.className = 'checkbox-icon';
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.flat.CheckBox.prototype.selectionChangeHandler = function(event) {
  if (this.input.checked)
    this.checkbox.className = 'checkbox-icon-checked';
  else
    this.checkbox.className = 'checkbox-icon';
};


Object.defineProperties(org.apache.flex.flat.CheckBox.prototype, /** @lends {org.apache.flex.flat.CheckBox.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.flat.CheckBox} */ function() {
  return this.textNode.nodeValue;
},
set: /** @this {org.apache.flex.flat.CheckBox} */ function(value) {
  this.textNode.nodeValue = value;
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.flat.CheckBox} */ function() {
  return this.input.checked;
},
set: /** @this {org.apache.flex.flat.CheckBox} */ function(value) {
  this.input.checked = value;
  if (value)
    this.checkbox.className = 'checkbox-icon-checked';
  else
    this.checkbox.className = 'checkbox-icon';
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.flat.CheckBox.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CheckBox', qName: 'org.apache.flex.flat.CheckBox'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.flat.CheckBox', org.apache.flex.flat.CheckBox);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.flat.CheckBox.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.flat.CheckBox'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.flat.CheckBox'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};