/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/events/BrowserEvent.as
 * org.apache.flex.events.BrowserEvent
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.events.BrowserEvent');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 */
org.apache.flex.events.BrowserEvent = function() {
};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.events.BrowserEvent.prototype.wrappedEvent;


/**
 * The underlying browser event object.
 * (for debugging purposes)
 *
 * @asreturn The underlying browser event object.
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @export
 * @return {Object}
 */
org.apache.flex.events.BrowserEvent.prototype.getBrowserEvent = function() {
  return this.wrappedEvent.getBrowserEvent();
};


/**
 * Tests to see which button was pressed during the event. This is really only
 * useful in IE and Gecko browsers. And in IE, it's only useful for
 * mousedown/mouseup events, because click only fires for the left mouse button.
 *
 * Safari 2 only reports the left button being clicked, and uses the value '1'
 * instead of 0. Opera only reports a mousedown event for the middle button, and
 * no mouse events for the right button. Opera has default behavior for left and
 * middle click that can only be overridden via a configuration setting.
 *
 * There's a nice table of this mess at http://www.unixpapa.com/js/mouse.html.
 *
 * @asparam button The button to test for.
 * @asreturn True if button was pressed.
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @export
 * @param {number} button
 * @return {boolean}
 */
org.apache.flex.events.BrowserEvent.prototype.isButton = function(button) {
  return this.wrappedEvent.isButton(button);
};


/**
 * Whether this has an "action"-producing mouse button.
 *
 * By definition, this includes left-click on windows/linux, and left-click
 * without the ctrl key on Macs.
 *
 * @asreturn The result.
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @export
 * @return {boolean}
 */
org.apache.flex.events.BrowserEvent.prototype.isMouseActionButton = function() {
  return this.wrappedEvent.isMouseActionButton();
};


/**
 * Whether the default action has been prevented.
 *
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.events.BrowserEvent.prototype.preventDefault = function() {
  this.wrappedEvent.preventDefault();
};


/**
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.events.BrowserEvent.prototype.stopImmediatePropagation = function() {
  this.wrappedEvent.stopPropagation();
};


/**
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.events.BrowserEvent.prototype.stopPropagation = function() {
  this.wrappedEvent.stopPropagation();
};


Object.defineProperties(org.apache.flex.events.BrowserEvent.prototype, /** @lends {org.apache.flex.events.BrowserEvent.prototype} */ {
/** @export */
altKey: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.altKey;
}},
/** @export */
button: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.button;
}},
/** @export */
charCode: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.charCode;
}},
/** @export */
clientX: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.clientX;
}},
/** @export */
clientY: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.clientY;
}},
/** @export */
ctrlKey: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.ctrlKey;
}},
/** @export */
currentTarget: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  var /** @type {Object} */ o = this.wrappedEvent.currentTarget;
  if (o && o.flexjs_wrapper)
    return o.flexjs_wrapper;
  return o;
}},
/** @export */
defaultPrevented: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.defaultPrevented;
}},
/** @export */
keyCode: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.keyCode;
}},
/** @export */
metaKey: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.metaKey;
}},
/** @export */
offsetX: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.offsetX;
}},
/** @export */
offsetY: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.offsetY;
}},
/** @export */
platformModifierKey: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.platformModifierKey;
}},
/** @export */
relatedTarget: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  var /** @type {Object} */ o = this.wrappedEvent.relatedTarget;
  if (o && o.flexjs_wrapper)
    return o.flexjs_wrapper;
  return o;
}},
/** @export */
screenX: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.screenX;
}},
/** @export */
screenY: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.screenY;
}},
/** @export */
shiftKey: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.shiftKey;
}},
/** @export */
state: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.state;
}},
/** @export */
target: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  var /** @type {Object} */ o = this.wrappedEvent.target;
  if (o && o.flexjs_wrapper)
    return o.flexjs_wrapper;
  return o;
}},
/** @export */
timestamp: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.timestamp;
}},
/** @export */
type: {
get: /** @this {org.apache.flex.events.BrowserEvent} */ function() {
  return this.wrappedEvent.type;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.events.BrowserEvent.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'BrowserEvent', qName: 'org.apache.flex.events.BrowserEvent'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.events.BrowserEvent', org.apache.flex.events.BrowserEvent);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.events.BrowserEvent.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'wrappedEvent': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
        'altKey': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'button': { type: 'uint', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'charCode': { type: 'uint', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'clientX': { type: 'Number', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'clientY': { type: 'Number', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'ctrlKey': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'currentTarget': { type: 'Object', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'defaultPrevented': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'keyCode': { type: 'uint', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'metaKey': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'offsetX': { type: 'Number', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'offsetY': { type: 'Number', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'platformModifierKey': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'relatedTarget': { type: 'Object', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'screenX': { type: 'Number', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'screenY': { type: 'Number', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'shiftKey': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'state': { type: 'Object', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'target': { type: 'Object', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'timestamp': { type: 'Date', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'type': { type: 'String', declaredBy: 'org.apache.flex.events.BrowserEvent'}
      };
    },
    methods: function () {
      return {
        'getBrowserEvent': { type: 'Object', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'isButton': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'isMouseActionButton': { type: 'Boolean', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'preventDefault': { type: 'void', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'stopImmediatePropagation': { type: 'void', declaredBy: 'org.apache.flex.events.BrowserEvent'},
        'stopPropagation': { type: 'void', declaredBy: 'org.apache.flex.events.BrowserEvent'}
      };
    }
  };
};