/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/tween/Sequence.as
 * org.apache.flex.createjs.tween.Sequence
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.tween.Sequence');

goog.require('org.apache.flex.createjs.tween.Effect');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @extends {org.apache.flex.createjs.tween.Effect}
 * @implements {org.apache.flex.core.IDocument}
 * @param {Object=} target
 */
org.apache.flex.createjs.tween.Sequence = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.createjs.tween.Sequence.base(this, 'constructor', target);
  this._tweens = [];
  
};
goog.inherits(org.apache.flex.createjs.tween.Sequence, org.apache.flex.createjs.tween.Effect);


/**
 * @private
 * @type {Array}
 */
org.apache.flex.createjs.tween.Sequence.prototype._tweens;


/**
 * @export
 * @param {org.apache.flex.createjs.tween.Effect} effect
 */
org.apache.flex.createjs.tween.Sequence.prototype.addEffect = function(effect) {
  this._tweens.push(effect);
};


/**
 * @private
 * @type {createjs.Tween}
 */
org.apache.flex.createjs.tween.Sequence.prototype._tween;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.createjs.tween.Sequence.prototype.document;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.createjs.tween.Sequence.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
  
};


/**
 *  Causes the effects in the tween list to be played, one after the other. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 *  @flexjsignorecoercion createjs.Shape
 *  @flexjsignorecoercion org.apache.flex.createjs.core.CreateJSBase
 * @export
 * @override
 */
org.apache.flex.createjs.tween.Sequence.prototype.play = function() {
  if (this.target != null) {
    this._actualTarget = this.document[this.target];
  }
  var /** @type {createjs.Shape} */ element = this._actualTarget.element;
  this._tween = createjs.Tween.get(element, {loop:this.loop});
  this._tween.setPaused(true);
  for (var /** @type {number} */ i = 0; i < this._tweens.length; i++) {
    var /** @type {org.apache.flex.createjs.tween.Effect} */ e = org.apache.flex.utils.Language.as(this._tweens[i], org.apache.flex.createjs.tween.Effect);
    var /** @type {Object} */ options = e.createTweenOptions();
    var /** @type {Function} */ useEasing = this.easing;
    if (e.easing != null)
      useEasing = e.easing;
    this._tween.to(options, e.duration, useEasing);
  }
  this._tween.setPaused(false);
  var /** @type {createjs.Stage} */ stage = element.getStage();
  createjs.Ticker.addEventListener("tick", stage);
  
};


Object.defineProperties(org.apache.flex.createjs.tween.Sequence.prototype, /** @lends {org.apache.flex.createjs.tween.Sequence.prototype} */ {
/** @export */
tweens: {
get: /** @this {org.apache.flex.createjs.tween.Sequence} */ function() {
  return this._tweens;
},
set: /** @this {org.apache.flex.createjs.tween.Sequence} */ function(value) {
  this._tweens = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.tween.Sequence.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Sequence', qName: 'org.apache.flex.createjs.tween.Sequence'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.tween.Sequence', org.apache.flex.createjs.tween.Sequence);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.tween.Sequence.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'tweens': { type: 'Array', declaredBy: 'org.apache.flex.createjs.tween.Sequence'}
      };
    },
    methods: function () {
      return {
        'Sequence': { type: '', declaredBy: 'org.apache.flex.createjs.tween.Sequence'},
        'addEffect': { type: 'void', declaredBy: 'org.apache.flex.createjs.tween.Sequence'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.createjs.tween.Sequence'},
        'play': { type: 'void', declaredBy: 'org.apache.flex.createjs.tween.Sequence'}
      };
    },
    metadata: function () { return [ ]; }
  };
};