/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/Label.as
 * org.apache.flex.createjs.Label
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.Label');

goog.require('org.apache.flex.createjs.core.CreateJSBase');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.core.ITextModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.createjs.core.CreateJSBase}
 */
org.apache.flex.createjs.Label = function() {
  org.apache.flex.createjs.Label.base(this, 'constructor');
};
goog.inherits(org.apache.flex.createjs.Label, org.apache.flex.createjs.core.CreateJSBase);


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.Label.prototype._fontName = "18px Arial";


/**
 * @asprivate
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.createjs.Label.prototype.createElement = function() {
  var /** @type {createjs.Text} */ text = new createjs.Text('default text');
  text.textBaseline = 'alphabetic';
  this.element = text;
  this.element.flexjs_wrapper = this;
  this.positioner = this.element;
  return this.element;
};


/**
 * @asprivate
 * @flexjsignorecoercion createjs.Text
 * @protected
 * @override
 */
org.apache.flex.createjs.Label.prototype.redrawShape = function() {
  var /** @type {string} */ color = null;
  if (this.textColor != null) {
    color = this.convertColorToString(org.apache.flex.utils.Language.as(this.textColor, org.apache.flex.graphics.SolidColor).color, 1.0);
  }
  var /** @type {createjs.Text} */ label = this.element;
  label.text = this.text;
  label["font"] = this.fontName;
  label["color"] = color;
};


Object.defineProperties(org.apache.flex.createjs.Label.prototype, /** @lends {org.apache.flex.createjs.Label.prototype} */ {
/** @export */
fontName: {
get: /** @this {org.apache.flex.createjs.Label} */ function() {
  return this._fontName;
},
set: /** @this {org.apache.flex.createjs.Label} */ function(value) {
  this._fontName = value;
  this.redrawShape();
}},
/** @export */
text: {
get: /** @this {org.apache.flex.createjs.Label} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITextModel, true).text;
},
set: /** @this {org.apache.flex.createjs.Label} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITextModel, true).text = value;
  this.redrawShape();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.Label.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Label', qName: 'org.apache.flex.createjs.Label'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.Label', org.apache.flex.createjs.Label);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.Label.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'fontName': { type: 'String', declaredBy: 'org.apache.flex.createjs.Label'},
        'text': { type: 'String', declaredBy: 'org.apache.flex.createjs.Label'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};