/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/HTMLElementWrapper.as
 * org.apache.flex.core.HTMLElementWrapper
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.HTMLElementWrapper');

goog.require('goog.events');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.BrowserEvent');
goog.require('org.apache.flex.events.ElementEvents');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IStrand');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IStrand}
 */
org.apache.flex.core.HTMLElementWrapper = function() {
  org.apache.flex.core.HTMLElementWrapper.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.HTMLElementWrapper, org.apache.flex.events.EventDispatcher);


/**
 * @asparam listener The listener object to call {goog.events.Listener}.
 * @asparam eventObject The event object to pass to the listener.
 * @asreturn Result of listener.
 * @export
 * @param {Object} listener
 * @param {org.apache.flex.events.BrowserEvent} eventObject
 * @return {boolean}
 */
org.apache.flex.core.HTMLElementWrapper.fireListenerOverride = function(listener, eventObject) {
  var /** @type {org.apache.flex.events.BrowserEvent} */ e = new org.apache.flex.events.BrowserEvent();
  e.wrappedEvent = eventObject;
  return org.apache.flex.core.HTMLElementWrapper.googFireListener(listener, e);
};


/**
 * Static initializer
 * @export
 * @return {boolean}
 */
org.apache.flex.core.HTMLElementWrapper.installOverride = function() {
  org.apache.flex.core.HTMLElementWrapper.googFireListener = goog.events.fireListener;
  goog.events.fireListener = org.apache.flex.core.HTMLElementWrapper.fireListenerOverride;
  return true;
};


/**
 * @export
 * @type {Function}
 */
org.apache.flex.core.HTMLElementWrapper.googFireListener;


/**
 * @export
 * @type {boolean}
 */
org.apache.flex.core.HTMLElementWrapper.installedOverride = org.apache.flex.core.HTMLElementWrapper.installOverride();


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.core.HTMLElementWrapper.prototype._element;


/**
 * @protected
 * @type {org.apache.flex.core.IBeadModel}
 */
org.apache.flex.core.HTMLElementWrapper.prototype._model;


/**
 * @protected
 * @type {Array}
 */
org.apache.flex.core.HTMLElementWrapper.prototype._beads;


/**
 * @asparam bead The new bead.
 * @export
 * @param {org.apache.flex.core.IBead} bead
 */
org.apache.flex.core.HTMLElementWrapper.prototype.addBead = function(bead) {
  if (!this._beads) {
    this._beads = new Array();
  }
  this._beads.push(bead);
  if (org.apache.flex.utils.Language.is(bead, org.apache.flex.core.IBeadModel)) {
    this._model = org.apache.flex.utils.Language.as(bead, org.apache.flex.core.IBeadModel);
  }
  bead.strand = this;
};


/**
 * @asparam classOrInterface The requested bead type.
 * @asreturn The bead.
 * @export
 * @param {Object} classOrInterface
 * @return {org.apache.flex.core.IBead}
 */
org.apache.flex.core.HTMLElementWrapper.prototype.getBeadByType = function(classOrInterface) {
  var /** @type {org.apache.flex.core.IBead} */ bead, /** @type {number} */ i, /** @type {number} */ n;
  if (!this._beads)
    return null;
  n = this._beads.length;
  for (i = 0; i < n; i++) {
    bead = this._beads[i];
    if (org.apache.flex.utils.Language.is(bead, classOrInterface)) {
      return bead;
    }
  }
  return null;
};


/**
 * @asparam bead The bead to remove.
 * @asreturn The bead.
 * @export
 * @param {org.apache.flex.core.IBead} bead
 * @return {org.apache.flex.core.IBead}
 */
org.apache.flex.core.HTMLElementWrapper.prototype.removeBead = function(bead) {
  var /** @type {number} */ i, /** @type {number} */ n, /** @type {Object} */ value;
  n = this._beads.length;
  for (i = 0; i < n; i++) {
    value = this._beads[i];
    if (bead === value) {
      this._beads.splice(i, 1);
      return bead;
    }
  }
  return null;
};


/**
 * @export
 * @override
 */
org.apache.flex.core.HTMLElementWrapper.prototype.addEventListener = function(type, handler, opt_capture, opt_handlerScope) {
  opt_capture = typeof opt_capture !== 'undefined' ? opt_capture : false;
  opt_handlerScope = typeof opt_handlerScope !== 'undefined' ? opt_handlerScope : null;
  var /** @type {Object} */ source = this.getActualDispatcher_(type);
  goog.events.listen(source, type, handler);
};


/**
 * @export
 * @override
 */
org.apache.flex.core.HTMLElementWrapper.prototype.removeEventListener = function(type, handler, opt_capture, opt_handlerScope) {
  opt_capture = typeof opt_capture !== 'undefined' ? opt_capture : false;
  opt_handlerScope = typeof opt_handlerScope !== 'undefined' ? opt_handlerScope : null;
  var /** @type {Object} */ source = this.getActualDispatcher_(type);
  goog.events.unlisten(source, type, handler);
};


/**
 * @private
 * @param {string} type
 * @return {Object}
 */
org.apache.flex.core.HTMLElementWrapper.prototype.getActualDispatcher_ = function(type) {
  var /** @type {Object} */ source = this;
  if (org.apache.flex.events.ElementEvents.elementEvents[type]) {
    source = this.element;
  }
  return source;
};


/**
 * @export
 * @override
 */
org.apache.flex.core.HTMLElementWrapper.prototype.hasEventListener = function(type) {
  var /** @type {Object} */ source = this.getActualDispatcher_(type);
  return goog.events.hasListener(source, type);
};


/**
 * @export
 * @override
 */
org.apache.flex.core.HTMLElementWrapper.prototype.dispatchEvent = function(e) {
  var /** @type {string} */ t;
  if (typeof(e) === 'string') {
    t = org.apache.flex.utils.Language.as(e, String);
    if (e === 'change')
      e = new Event(t);
  } else {
    t = org.apache.flex.utils.Language.string(e.type);
    if (org.apache.flex.events.ElementEvents.elementEvents[t]) {
      e = new Event(t);
    }
  }
  var /** @type {Object} */ source = this.getActualDispatcher_(t);
  if (source == this)
    return org.apache.flex.core.HTMLElementWrapper.base(this, 'dispatchEvent', e);
  return source.dispatchEvent(e);
};


Object.defineProperties(org.apache.flex.core.HTMLElementWrapper.prototype, /** @lends {org.apache.flex.core.HTMLElementWrapper.prototype} */ {
/** @export */
element: {
get: /** @this {org.apache.flex.core.HTMLElementWrapper} */ function() {
  return this._element;
},
set: /** @this {org.apache.flex.core.HTMLElementWrapper} */ function(value) {
  this._element = value;
}},
/** @export */
model: {
get: /** @this {org.apache.flex.core.HTMLElementWrapper} */ function() {
  if (this._model == null) {
    var /** @type {Object} */ m = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, 'iBeadModel');
    var /** @type {org.apache.flex.core.IBeadModel} */ b = new m();
    this.addBead(b);
  }
  return this._model;
},
set: /** @this {org.apache.flex.core.HTMLElementWrapper} */ function(value) {
  if (this._model != value) {
    this.addBead(org.apache.flex.utils.Language.as(value, org.apache.flex.core.IBead));
    this.dispatchEvent(new org.apache.flex.events.Event("modelChanged"));
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.HTMLElementWrapper.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'HTMLElementWrapper', qName: 'org.apache.flex.core.HTMLElementWrapper'}], interfaces: [org.apache.flex.core.IStrand] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.HTMLElementWrapper', org.apache.flex.core.HTMLElementWrapper);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.HTMLElementWrapper.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'element': { type: 'WrappedHTMLElement', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'model': { type: 'Object', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'}
      };
    },
    methods: function () {
      return {
        'addBead': { type: 'void', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'getBeadByType': { type: 'IBead', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'removeBead': { type: 'IBead', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'addEventListener': { type: 'void', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'removeEventListener': { type: 'void', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'hasEventListener': { type: 'Boolean', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'},
        'dispatchEvent': { type: 'Boolean', declaredBy: 'org.apache.flex.core.HTMLElementWrapper'}
      };
    }
  };
};