/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/FormatBase.as
 * org.apache.flex.core.FormatBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.FormatBase');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IFormatBead');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IFormatBead}
 */
org.apache.flex.core.FormatBase = function() {
  org.apache.flex.core.FormatBase.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.FormatBase, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.FormatBase.prototype._propertyName;


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.FormatBase.prototype._eventName;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.core.FormatBase.prototype._strand;


Object.defineProperties(org.apache.flex.core.FormatBase.prototype, /** @lends {org.apache.flex.core.FormatBase.prototype} */ {
/** @export */
propertyValue: {
get: /** @this {org.apache.flex.core.FormatBase} */ function() {
  var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadModel), org.apache.flex.core.IBeadModel);
  var /** @type {Object} */ value = model[this.propertyName];
  return value;
}},
/** @export */
propertyName: {
get: /** @this {org.apache.flex.core.FormatBase} */ function() {
  if (this._propertyName == null) {
    this._propertyName = "text";
  }
  return this._propertyName;
},
set: /** @this {org.apache.flex.core.FormatBase} */ function(value) {
  this._propertyName = value;
}},
/** @export */
eventName: {
get: /** @this {org.apache.flex.core.FormatBase} */ function() {
  if (this._eventName == null) {
    return this._propertyName + "Changed";
  }
  return this._eventName;
},
set: /** @this {org.apache.flex.core.FormatBase} */ function(value) {
  this._eventName = value;
}},
/** @export */
formattedString: {
get: /** @this {org.apache.flex.core.FormatBase} */ function() {
  return null;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.core.FormatBase} */ function(value) {
  this._strand = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.FormatBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'FormatBase', qName: 'org.apache.flex.core.FormatBase'}], interfaces: [org.apache.flex.core.IFormatBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.FormatBase', org.apache.flex.core.FormatBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.FormatBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'propertyValue': { type: 'Object', declaredBy: 'org.apache.flex.core.FormatBase'},
        'propertyName': { type: 'String', declaredBy: 'org.apache.flex.core.FormatBase'},
        'eventName': { type: 'String', declaredBy: 'org.apache.flex.core.FormatBase'},
        'formattedString': { type: 'String', declaredBy: 'org.apache.flex.core.FormatBase'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.core.FormatBase'}
      };
    },
    methods: function () {
      return {
        'FormatBase': { type: '', declaredBy: 'org.apache.flex.core.FormatBase'}
      };
    }
  };
};