/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/BrowserResizeListener.as
 * org.apache.flex.core.BrowserResizeListener
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.BrowserResizeListener');

goog.require('org.apache.flex.core.Application');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.core.BrowserResizeListener = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.Application}
 */
org.apache.flex.core.BrowserResizeListener.prototype.app;


/**
 * @export
 * @type {number}
 */
org.apache.flex.core.BrowserResizeListener.prototype.minHeight;


/**
 * @export
 * @type {number}
 */
org.apache.flex.core.BrowserResizeListener.prototype.minWidth;


/**
 * @private
 * @param {Event} event
 */
org.apache.flex.core.BrowserResizeListener.prototype.resizeHandler = function(event) {
  
  var /** @type {org.apache.flex.core.UIBase} */ initialView = org.apache.flex.utils.Language.as(this.app.initialView, org.apache.flex.core.UIBase);
  var /** @type {HTMLElement} */ element = this.app.element;
  if (!isNaN(initialView.percentWidth) || !isNaN(initialView.percentHeight)) {
    element.style.height = window.innerHeight.toString() + 'px';
    element.style.width = window.innerWidth.toString() + 'px';
    initialView.dispatchEvent('sizeChanged');
  }
};


Object.defineProperties(org.apache.flex.core.BrowserResizeListener.prototype, /** @lends {org.apache.flex.core.BrowserResizeListener.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.core.BrowserResizeListener} */ function(value) {
  this.app = org.apache.flex.utils.Language.as(value, org.apache.flex.core.Application);
  
  window.addEventListener('resize', org.apache.flex.utils.Language.closure(this.resizeHandler, this, 'resizeHandler'), false);
  if (!isNaN(this.minWidth))
    document.body.style.minWidth = this.minWidth.toString() + 'px';
  if (!isNaN(this.minHeight))
    document.body.style.minHeight = this.minHeight.toString() + 'px';
  document.body.style.overflow = 'auto';
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.BrowserResizeListener.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'BrowserResizeListener', qName: 'org.apache.flex.core.BrowserResizeListener'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.BrowserResizeListener', org.apache.flex.core.BrowserResizeListener);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.BrowserResizeListener.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'minHeight': { type: 'Number'},
        'minWidth': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.core.BrowserResizeListener'}
      };
    },
    methods: function () {
      return {
        'BrowserResizeListener': { type: '', declaredBy: 'org.apache.flex.core.BrowserResizeListener'}
      };
    }
  };
};