/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/supportClasses/BoxItemRenderer.as
 * org.apache.flex.charts.supportClasses.BoxItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.supportClasses.BoxItemRenderer');

goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.html.supportClasses.DataItemRenderer');
goog.require('org.apache.flex.svg.LinearGradient');
goog.require('org.apache.flex.svg.Rect');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.DataItemRenderer}
 * @implements {org.apache.flex.charts.core.IChartItemRenderer}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer = function() {
  org.apache.flex.charts.supportClasses.BoxItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.supportClasses.BoxItemRenderer, org.apache.flex.html.supportClasses.DataItemRenderer);


/**
 * @export
 * @override
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.addedToParent = function() {
  org.apache.flex.charts.supportClasses.BoxItemRenderer.base(this, 'addedToParent');
};


/**
 * @export
 * @override
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.addBead = function(bead) {
  org.apache.flex.charts.supportClasses.BoxItemRenderer.base(this, 'addBead', bead);
};


/**
 * @private
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype._series;


/**
 * @private
 * @type {org.apache.flex.svg.Rect}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.filledRect;


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype._yField = "y";


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype._xField = "x";


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype._fill;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype._stroke;


/**
 *  @asprivate
 * @protected
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.drawBar = function() {
  if ((this.width > 0) && (this.height > 0)) {
    var /** @type {boolean} */ needsAdd = false;
    if (this.filledRect == null) {
      this.filledRect = new org.apache.flex.svg.Rect();
      needsAdd = true;
    }
    this.filledRect.fill = this.fill;
    this.filledRect.stroke = this.stroke;
    this.filledRect.x = 0;
    this.filledRect.y = 0;
    this.filledRect.width = this.width;
    this.filledRect.height = this.height;
    if (needsAdd) {
      this.addElement(this.filledRect);
    }
  }
};


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.hoverFill;


/**
 * @export
 * @override
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.updateRenderer = function() {
  if (this.down || this.selected || this.hovered) {
    if (this.hoverFill == null) {
      if (org.apache.flex.utils.Language.is(this.fill, org.apache.flex.graphics.SolidColor)) {
        this.hoverFill = new org.apache.flex.graphics.SolidColor();
        org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.graphics.SolidColor).color = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).color;
        org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.graphics.SolidColor).alpha = 0.65;
      } else if (org.apache.flex.utils.Language.is(this.fill, org.apache.flex.svg.LinearGradient)) {
        this.hoverFill = new org.apache.flex.svg.LinearGradient();
        org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.svg.LinearGradient).entries = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.svg.LinearGradient).entries;
        for (var /** @type {number} */ i = 0; i < org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.svg.LinearGradient).entries; i++) {
          org.apache.flex.utils.Language.as(this.hoverFill, org.apache.flex.svg.LinearGradient).entries[i].alpha = 0.65;
        }
      }
    }
    this.filledRect.fill = this.hoverFill;
  } else {
    this.filledRect.fill = this.fill;
  }
  this.filledRect.drawRect(this.filledRect.x, this.filledRect.y, this.filledRect.width, this.filledRect.height);
};


Object.defineProperties(org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype, /** @lends {org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype} */ {
/** @export */
series: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
  return this._series;
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  this._series = value;
}},
/** @export */
yField: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
  return this._yField;
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  this._yField = value;
}},
/** @export */
xField: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
  return this._xField;
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  this._xField = value;
}},
/** @export */
fill: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
  return this._fill;
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  this._fill = value;
}},
/** @export */
stroke: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  this._stroke = value;
}},
/** @export */
data: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.charts.supportClasses.BoxItemRenderer, this, 'data');
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.supportClasses.BoxItemRenderer, this, 'data', value);
  this.drawBar();
}},
/** @export */
width: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.charts.supportClasses.BoxItemRenderer, this, 'width');
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.supportClasses.BoxItemRenderer, this, 'width', value);
  this.drawBar();
}},
/** @export */
height: {
get: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.charts.supportClasses.BoxItemRenderer, this, 'height');
},
set: /** @this {org.apache.flex.charts.supportClasses.BoxItemRenderer} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.supportClasses.BoxItemRenderer, this, 'height', value);
  this.drawBar();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'BoxItemRenderer', qName: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'}], interfaces: [org.apache.flex.charts.core.IChartItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.supportClasses.BoxItemRenderer', org.apache.flex.charts.supportClasses.BoxItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.supportClasses.BoxItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'series': { type: 'IChartSeries', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'yField': { type: 'String', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'xField': { type: 'String', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'fill': { type: 'IFill', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'data': { type: 'Object', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'width': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'height': { type: 'Number', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'}
      };
    },
    methods: function () {
      return {
        'BoxItemRenderer': { type: '', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'addBead': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'},
        'updateRenderer': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.BoxItemRenderer'}
      };
    }
  };
};