/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/optimized/SVGChartAxisGroup.as
 * org.apache.flex.charts.optimized.SVGChartAxisGroup
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.optimized.SVGChartAxisGroup');

goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.charts.core.IAxisGroup');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.svg.CompoundGraphic}
 * @implements {org.apache.flex.charts.core.IAxisGroup}
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup = function() {
  org.apache.flex.charts.optimized.SVGChartAxisGroup.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.optimized.SVGChartAxisGroup, org.apache.flex.svg.CompoundGraphic);


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.addedToParent = function() {
  org.apache.flex.charts.optimized.SVGChartAxisGroup.base(this, 'addedToParent');
};


/**
 * Draws a horizontal tick label centered in the box at the given position.
 * 
 * @asparam text The label to display.
 * @asparam xpos The x position of the label's upper left corner.
 * @asparam ypos The y position of the label's upper left corner.
 * @asparam boxWith The size of the box into which the label should be drawn.
 * @asparam boxHeight The size of the box into which the label should be drawn.
 * @asparam tickFill A fill to use to display the label.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} text
 * @param {number} xpos
 * @param {number} ypos
 * @param {number} boxWidth
 * @param {number} boxHeight
 * @param {org.apache.flex.graphics.IFill} tickFill
 * @return {Object}
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.drawHorizontalTickLabel = function(text, xpos, ypos, boxWidth, boxHeight, tickFill) {
  this.fill = tickFill;
  return this.drawText(text, xpos - boxWidth / 2, ypos);
};


/**
 * Draws a vertical tick label centered in the box at the given position.
 * 
 * @asparam text The label to display.
 * @asparam xpos The x position of the label's upper left corner.
 * @asparam ypos The y position of the label's upper left corner.
 * @asparam boxWith The size of the box into which the label should be drawn.
 * @asparam boxHeight The size of the box into which the label should be drawn.
 * @asparam tickFill A fill to use to display the label.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} text
 * @param {number} xpos
 * @param {number} ypos
 * @param {number} boxWidth
 * @param {number} boxHeight
 * @param {org.apache.flex.graphics.IFill} tickFill
 * @return {Object}
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.drawVerticalTickLabel = function(text, xpos, ypos, boxWidth, boxHeight, tickFill) {
  this.fill = tickFill;
  return this.drawText(text, xpos, ypos - boxHeight / 4);
};


/**
 * Draws an set of tick marks are determined in the marks path.
 * 
 * @asparam originX The upper left corner of the space into which the tick marks are drawn.
 * @asparam originY The upper left corner of the space into which the tick marks are drawn.
 * @asparam width The size of the box into which the tick marks are drawn.
 * @asparam height The size of the box into which the tick marks are drawn.
 * @asparam tickStroke The stroke to use to display the tick marks.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} originX
 * @param {number} originY
 * @param {number} width
 * @param {number} height
 * @param {string} marks
 * @param {org.apache.flex.graphics.IStroke} tickStroke
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.drawTickMarks = function(originX, originY, width, height, marks, tickStroke) {
  this.stroke = tickStroke;
  this.drawStringPath(marks);
};


/**
 * Draws the axis line at the given position.
 * 
 * @asparam originX The upper left corner of the space into which the axis line is drawn.
 * @asparam originY The upper left corner of the space into which the axis line is drawn.
 * @asparam width The size of the box into which the line is drawn.
 * @asparam height The size of the box into which the line is drawn.
 * @asparam lineStroke The stroke to use to display the line.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} originX
 * @param {number} originY
 * @param {number} width
 * @param {number} height
 * @param {org.apache.flex.graphics.IStroke} lineStroke
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.drawAxisLine = function(originX, originY, width, height, lineStroke) {
  this.stroke = lineStroke;
  var /** @type {string} */ pathLine = "M " + String(originX) + " " + String(originY) + " l " + String(width) + " " + String(height);
  this.drawStringPath(pathLine);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SVGChartAxisGroup', qName: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'}], interfaces: [org.apache.flex.charts.core.IAxisGroup] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.optimized.SVGChartAxisGroup', org.apache.flex.charts.optimized.SVGChartAxisGroup);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.optimized.SVGChartAxisGroup.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'SVGChartAxisGroup': { type: '', declaredBy: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'},
        'drawHorizontalTickLabel': { type: 'Object', declaredBy: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'},
        'drawVerticalTickLabel': { type: 'Object', declaredBy: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'},
        'drawTickMarks': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'},
        'drawAxisLine': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartAxisGroup'}
      };
    }
  };
};