/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/layouts/PieChartLayout.as
 * org.apache.flex.charts.beads.layouts.PieChartLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.layouts.PieChartLayout');

goog.require('org.apache.flex.charts.beads.layouts.ChartBaseLayout');
goog.require('org.apache.flex.charts.supportClasses.PieSeries');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.charts.supportClasses.IWedgeItemRenderer');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.charts.beads.layouts.ChartBaseLayout}
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.charts.beads.layouts.PieChartLayout = function() {
  org.apache.flex.charts.beads.layouts.PieChartLayout.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.beads.layouts.PieChartLayout, org.apache.flex.charts.beads.layouts.ChartBaseLayout);


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.layouts.PieChartLayout.prototype.performLayout = function() {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(selectionModel.dataProvider, Array);
  if (!dp)
    return;
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.core.IParentIUIBase);
  var /** @type {number} */ n = dp.length;
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ useWidth = contentView.width;
  var /** @type {number} */ useHeight = contentView.height;
  var /** @type {number} */ maxYValue = 0;
  var /** @type {Array} */ seriesMaxes = [];
  var /** @type {Array} */ colors = [0xFF964D, 0x964DFF, 0xF80012, 0x96FF4D, 0x4D96FF, 0x8A8A01, 0x23009C, 0x4A4A4A, 0x23579D];
  for (var /** @type {number} */ s = 0; s < this.chart.series.length; s++) {
    var /** @type {org.apache.flex.charts.supportClasses.PieSeries} */ pcs = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.supportClasses.PieSeries);
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {Object} */ data = dp[i];
      var /** @type {string} */ field = pcs.dataField;
      var /** @type {number} */ yValue = Number(data[field]);
      maxYValue += yValue;
      seriesMaxes.push({yValue:yValue, percent:0, arc:0});
    }
    for (i = 0; i < n; i++) {
      var /** @type {Object} */ obj = seriesMaxes[i];
      obj.percent = obj.yValue / maxYValue;
      obj.arc = 360.0 * obj.percent;
    }
    var /** @type {number} */ start = 0;
    var /** @type {number} */ end = 0;
    var /** @type {number} */ radius = Math.min(useWidth, useHeight) / 2;
    var /** @type {number} */ centerX = useWidth / 2;
    var /** @type {number} */ centerY = useHeight / 2;
    for (i = 0; i < n; i++) {
      obj = seriesMaxes[i];
      data = dp[i];
      var /** @type {org.apache.flex.graphics.SolidColor} */ fill = new org.apache.flex.graphics.SolidColor();
      fill.color = Number(colors[i % colors.length]);
      fill.alpha = 1.0;
      var /** @type {org.apache.flex.charts.supportClasses.IWedgeItemRenderer} */ child = org.apache.flex.utils.Language.as(this.chartDataGroup.getItemRendererForSeriesAtIndex(this.chart.series[s], i), org.apache.flex.charts.supportClasses.IWedgeItemRenderer);
      child.fill = fill;
      end = start + (360.0 * obj.percent);
      var /** @type {number} */ arc = 360.0 * obj.percent;
      child.x = 0;
      child.y = 0;
      child.width = useWidth;
      child.height = useHeight;
      child.centerX = centerX;
      child.centerY = centerY;
      child.startAngle = start * Math.PI / 180;
      child.arc = arc * Math.PI / 180;
      child.radius = radius;
      start += arc;
    }
  }
  org.apache.flex.utils.Language.as(this.chart, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutComplete"));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.layouts.PieChartLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PieChartLayout', qName: 'org.apache.flex.charts.beads.layouts.PieChartLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.layouts.PieChartLayout', org.apache.flex.charts.beads.layouts.PieChartLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.layouts.PieChartLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'PieChartLayout': { type: '', declaredBy: 'org.apache.flex.charts.beads.layouts.PieChartLayout'}
      };
    }
  };
};