/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/layouts/LineChartLinearVsLinearLayout.as
 * org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout');

goog.require('org.apache.flex.charts.beads.layouts.ChartBaseLayout');
goog.require('org.apache.flex.charts.supportClasses.LineSeries');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.charts.core.ICartesianChartLayout');
goog.require('org.apache.flex.charts.core.IChartSeries');
goog.require('org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.charts.beads.layouts.ChartBaseLayout}
 * @implements {org.apache.flex.core.IBeadLayout}
 * @implements {org.apache.flex.charts.core.ICartesianChartLayout}
 */
org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout = function() {
  org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout, org.apache.flex.charts.beads.layouts.ChartBaseLayout);


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout.prototype.performLayout = function() {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(selectionModel.dataProvider, Array);
  if (!dp)
    return;
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.core.IParentIUIBase);
  var /** @type {number} */ n = dp.length;
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ ypos = 0;
  var /** @type {number} */ useWidth = contentView.width;
  var /** @type {number} */ useHeight = contentView.height;
  var /** @type {number} */ itemWidth = useWidth / dp.length;
  var /** @type {number} */ maxXValue = 0;
  var /** @type {number} */ minXValue = 0;
  var /** @type {number} */ maxYValue = 0;
  var /** @type {number} */ minYValue = 0;
  var /** @type {number} */ scaleXFactor = 1;
  var /** @type {number} */ scaleYFactor = 1;
  var /** @type {boolean} */ determineYScale = true;
  var /** @type {boolean} */ determineXScale = true;
  if (this.horizontalAxisBead != null && !isNaN(this.horizontalAxisBead.maximum)) {
    maxXValue = this.horizontalAxisBead.maximum;
    determineXScale = false;
  }
  if (this.horizontalAxisBead != null && !isNaN(this.horizontalAxisBead.minimum)) {
    minXValue = this.horizontalAxisBead.minimum;
  }
  if (this.verticalAxisBead != null && !isNaN(this.verticalAxisBead.maximum)) {
    maxYValue = this.verticalAxisBead.maximum;
    determineYScale = false;
  }
  if (this.verticalAxisBead != null && !isNaN(this.verticalAxisBead.minimum)) {
    minYValue = this.verticalAxisBead.minimum;
  }
  var /** @type {Array} */ seriesPoints = [];
  for (var /** @type {number} */ s = 0; s < this.chart.series.length; s++) {
    var /** @type {org.apache.flex.charts.core.IChartSeries} */ aseries = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.core.IChartSeries);
    seriesPoints.push({points:[]});
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {Object} */ data = dp[i];
      var /** @type {string} */ xfield = aseries.xField;
      var /** @type {string} */ yfield = aseries.yField;
      var /** @type {number} */ xValue = Number(data[xfield]);
      if (determineXScale)
        maxXValue = Math.max(maxXValue, xValue);
      var /** @type {number} */ yValue = Number(data[yfield]);
      if (determineYScale)
        maxYValue = Math.max(maxYValue, yValue);
    }
  }
  scaleXFactor = useWidth / (maxXValue - minXValue);
  scaleYFactor = useHeight / (maxYValue - minYValue);
  for (s = 0; s < this.chart.series.length; s++) {
    aseries = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.core.IChartSeries);
    for (i = 0; i < n; i++) {
      data = dp[i];
      xValue = Number(data[aseries.xField]) - minXValue;
      yValue = Number(data[aseries.yField]) - minYValue;
      var /** @type {number} */ childX = (xValue * scaleXFactor);
      var /** @type {number} */ childY = useHeight - (yValue * scaleYFactor);
      seriesPoints[s].points.push({x:childX, y:childY});
      var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ child = this.chartDataGroup.getItemRendererForSeriesAtIndex(aseries, i);
      if (child) {
        child.x = childX - 5;
        child.y = childY - 5;
        child.width = 10;
        child.height = 10;
      }
    }
  }
  for (s = 0; s < this.chart.series.length; s++) {
    var /** @type {org.apache.flex.charts.supportClasses.LineSeries} */ lcs = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.supportClasses.LineSeries);
    if (lcs.lineSegmentRenderer) {
      var /** @type {org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer} */ renderer = org.apache.flex.utils.Language.as(lcs.lineSegmentRenderer.newInstance(), org.apache.flex.charts.supportClasses.ILineSegmentItemRenderer);
      this.chartDataGroup.addElement(renderer);
      renderer.itemRendererParent = this.chartDataGroup;
      renderer.data = lcs;
      renderer.points = seriesPoints[s].points;
    }
  }
  org.apache.flex.utils.Language.as(this.chart, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutComplete"));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LineChartLinearVsLinearLayout', qName: 'org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout'}], interfaces: [org.apache.flex.core.IBeadLayout, org.apache.flex.charts.core.ICartesianChartLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout', org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'LineChartLinearVsLinearLayout': { type: '', declaredBy: 'org.apache.flex.charts.beads.layouts.LineChartLinearVsLinearLayout'}
      };
    }
  };
};