/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/layouts/ColumnChartLayout.as
 * org.apache.flex.charts.beads.layouts.ColumnChartLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.layouts.ColumnChartLayout');

goog.require('org.apache.flex.charts.beads.layouts.ChartBaseLayout');
goog.require('org.apache.flex.charts.supportClasses.ColumnSeries');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.charts.core.ICartesianChartLayout');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.charts.beads.layouts.ChartBaseLayout}
 * @implements {org.apache.flex.core.IBeadLayout}
 * @implements {org.apache.flex.charts.core.ICartesianChartLayout}
 */
org.apache.flex.charts.beads.layouts.ColumnChartLayout = function() {
  org.apache.flex.charts.beads.layouts.ColumnChartLayout.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.beads.layouts.ColumnChartLayout, org.apache.flex.charts.beads.layouts.ChartBaseLayout);


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.layouts.ColumnChartLayout.prototype._gap = 20;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.layouts.ColumnChartLayout.prototype.performLayout = function() {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(selectionModel.dataProvider, Array);
  if (!dp)
    return;
  var /** @type {number} */ n = dp.length;
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ useWidth = org.apache.flex.utils.Language.as(this.chartDataGroup, org.apache.flex.core.UIBase, true).width;
  var /** @type {number} */ useHeight = org.apache.flex.utils.Language.as(this.chartDataGroup, org.apache.flex.core.UIBase, true).height;
  var /** @type {number} */ itemWidth = (useWidth - this.gap * (dp.length - 1)) / dp.length;
  var /** @type {number} */ seriesWidth = itemWidth / this.chart.series.length;
  var /** @type {number} */ maxYValue = 0;
  var /** @type {number} */ minYValue = 0;
  var /** @type {number} */ scaleFactor = 1;
  var /** @type {boolean} */ determineScale = true;
  if (this.verticalAxisBead != null && !isNaN(this.verticalAxisBead.maximum)) {
    maxYValue = this.verticalAxisBead.maximum;
    determineScale = false;
  }
  if (this.verticalAxisBead != null && !isNaN(this.verticalAxisBead.minimum)) {
    minYValue = this.verticalAxisBead.minimum;
  }
  for (var /** @type {number} */ s = 0; s < this.chart.series.length; s++) {
    var /** @type {org.apache.flex.charts.supportClasses.ColumnSeries} */ bcs = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.supportClasses.ColumnSeries);
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {Object} */ data = dp[i];
      var /** @type {string} */ field = bcs.yField;
      var /** @type {number} */ yValue = Number(data[field]);
      if (determineScale)
        maxYValue = Math.max(yValue, maxYValue);
    }
  }
  var /** @type {number} */ range = maxYValue - minYValue;
  scaleFactor = useHeight / range;
  for (i = 0; i < n; i++) {
    data = dp[i];
    for (s = 0; s < this.chart.series.length; s++) {
      bcs = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.supportClasses.ColumnSeries);
      var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ child = this.chartDataGroup.getItemRendererForSeriesAtIndex(bcs, i);
      yValue = Number(data[bcs.yField]) - minYValue;
      if (yValue > maxYValue)
        yValue = maxYValue;
      yValue = yValue * scaleFactor;
      child.y = useHeight - yValue;
      child.x = xpos;
      child.width = seriesWidth;
      child.height = yValue;
      xpos += seriesWidth;
    }
    xpos += this.gap;
  }
  org.apache.flex.utils.Language.as(this.chart, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutComplete"));
};


Object.defineProperties(org.apache.flex.charts.beads.layouts.ColumnChartLayout.prototype, /** @lends {org.apache.flex.charts.beads.layouts.ColumnChartLayout.prototype} */ {
/** @export */
gap: {
get: /** @this {org.apache.flex.charts.beads.layouts.ColumnChartLayout} */ function() {
  return this._gap;
},
set: /** @this {org.apache.flex.charts.beads.layouts.ColumnChartLayout} */ function(value) {
  this._gap = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.layouts.ColumnChartLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ColumnChartLayout', qName: 'org.apache.flex.charts.beads.layouts.ColumnChartLayout'}], interfaces: [org.apache.flex.core.IBeadLayout, org.apache.flex.charts.core.ICartesianChartLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.layouts.ColumnChartLayout', org.apache.flex.charts.beads.layouts.ColumnChartLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.layouts.ColumnChartLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'gap': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.layouts.ColumnChartLayout'}
      };
    },
    methods: function () {
      return {
        'ColumnChartLayout': { type: '', declaredBy: 'org.apache.flex.charts.beads.layouts.ColumnChartLayout'}
      };
    }
  };
};