/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/AxisBaseBead.as
 * org.apache.flex.charts.beads.AxisBaseBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.AxisBaseBead');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.charts.core.IAxisBead');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.charts.core.IAxisBead}
 */
org.apache.flex.charts.beads.AxisBaseBead = function() {
  var /** @type {org.apache.flex.graphics.SolidColorStroke} */ blackLine = new org.apache.flex.graphics.SolidColorStroke();
  blackLine.color = 0x111111;
  blackLine.weight = 1;
  blackLine.alpha = 1.0;
  this.axisStroke = blackLine;
  this.tickStroke = blackLine;
  var /** @type {org.apache.flex.graphics.SolidColor} */ blackFill = new org.apache.flex.graphics.SolidColor();
  blackFill.color = 0x111111;
  blackFill.alpha = 1.0;
  this.tickFill = blackFill;
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype._strand;


/**
 * @private
 * @type {org.apache.flex.svg.CompoundGraphic}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.wrapper;


/**
 * @private
 * @type {org.apache.flex.charts.core.IAxisGroup}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype._axisGroup;


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype._placement = "unset";


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype._axisStroke;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype._tickStroke;


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype._tickFill;


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.tickPathString = null;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.tickMaxWidth = 0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.tickMaxHeight = 0;


/**
 * Removes all graphic elements.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.clearGraphics = function() {
  this.axisGroup.removeAllElements();
};


/**
 * @asprivate
 * @protected
 * @param {number} originX
 * @param {number} originY
 * @param {number} xoffset
 * @param {number} yoffset
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.drawAxisPath = function(originX, originY, xoffset, yoffset) {
  this.axisGroup.drawAxisLine(originX, originY, xoffset, yoffset, this.axisStroke);
};


/**
 * @asprivate
 * @protected
 * @param {string} text
 * @param {number} xpos
 * @param {number} ypos
 * @param {number} boxWidth
 * @param {number} boxHeight
 * @return {Object}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.addTickLabel = function(text, xpos, ypos, boxWidth, boxHeight) {
  var /** @type {boolean} */ isHorizontal = (this.placement == "bottom") || (this.placement == "top");
  var /** @type {Object} */ label;
  if (isHorizontal)
    label = this.axisGroup.drawHorizontalTickLabel(text, xpos, ypos, boxWidth, boxHeight, this.tickFill);
  else
    label = this.axisGroup.drawVerticalTickLabel(text, xpos, ypos, boxWidth, boxHeight, this.tickFill);
  return label;
};


/**
 * @asprivate
 * @protected
 * @param {number} xpos
 * @param {number} ypos
 * @param {number} xoffset
 * @param {number} yoffset
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.addTickMark = function(xpos, ypos, xoffset, yoffset) {
  if (this.tickPathString == null)
    this.tickPathString = "";
  this.tickPathString = this.tickPathString + " M " + String(xpos) + " " + String(ypos);
  this.tickPathString = this.tickPathString + " l " + String(xoffset) + " " + String(yoffset);
  this.tickMaxWidth = Math.max(this.tickMaxWidth, xpos + xoffset);
  this.tickMaxHeight = Math.max(this.tickMaxHeight, ypos + yoffset);
};


/**
 * @asprivate
 * @protected
 * @param {number} originX
 * @param {number} originY
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.drawTickPath = function(originX, originY) {
  this.axisGroup.drawTickMarks(originX, originY, this.tickMaxWidth, this.tickMaxHeight, this.tickPathString, this.tickStroke);
  this.tickPathString = null;
};


Object.defineProperties(org.apache.flex.charts.beads.AxisBaseBead.prototype, /** @lends {org.apache.flex.charts.beads.AxisBaseBead.prototype} */ {
/** @export */
placement: {
get: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function() {
  return this._placement;
},
set: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function(value) {
  this._placement = value;
}},
/** @export */
axisStroke: {
get: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function() {
  return this._axisStroke;
},
set: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function(value) {
  this._axisStroke = value;
}},
/** @export */
tickStroke: {
get: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function() {
  return this._tickStroke;
},
set: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function(value) {
  this._tickStroke = value;
}},
/** @export */
tickFill: {
get: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function() {
  return this._tickFill;
},
set: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function(value) {
  this._tickFill = value;
}},
/** @export */
axisGroup: {
get: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function() {
  return this._axisGroup;
},
set: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function(value) {
  this._axisGroup = value;
  this.wrapper = new org.apache.flex.svg.CompoundGraphic();
  org.apache.flex.utils.Language.as(this._axisGroup, org.apache.flex.core.UIBase, true).addElement(this.wrapper);
  this.wrapper.x = 0;
  this.wrapper.y = 0;
  this.wrapper.width = org.apache.flex.utils.Language.as(this._axisGroup, org.apache.flex.core.UIBase, true).width;
  this.wrapper.height = org.apache.flex.utils.Language.as(this._axisGroup, org.apache.flex.core.UIBase, true).height;
}},
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.AxisBaseBead} */ function(value) {
  this._strand = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'AxisBaseBead', qName: 'org.apache.flex.charts.beads.AxisBaseBead'}], interfaces: [org.apache.flex.charts.core.IAxisBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.AxisBaseBead', org.apache.flex.charts.beads.AxisBaseBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.AxisBaseBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'placement': { type: 'String', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'},
        'axisStroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'},
        'tickStroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'},
        'tickFill': { type: 'IFill', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'},
        'axisGroup': { type: 'IAxisGroup', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'}
      };
    },
    methods: function () {
      return {
        'AxisBaseBead': { type: '', declaredBy: 'org.apache.flex.charts.beads.AxisBaseBead'}
      };
    }
  };
};