/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/LatLng.as
 * google.maps.LatLng
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.LatLng');



/**
 * @asparam lat [number] 
 * @asparam lng [number] 
 * @asparam opt_noWrap [(boolean|undefined)] 
 * @see [google_maps_api_v3_11]
 * @constructor
 * @param {number} lat
 * @param {number} lng
 * @param {boolean=} opt_noWrap
 */
google.maps.LatLng = function(lat, lng, opt_noWrap) {
  opt_noWrap = typeof opt_noWrap !== 'undefined' ? opt_noWrap : false;
  ;
  this._lat = lat;
  this._lng = lng;
};


/**
 * @private
 * @type {number}
 */
google.maps.LatLng.prototype._lat;


/**
 * @private
 * @type {number}
 */
google.maps.LatLng.prototype._lng;


/**
 * @asparam other [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @param {google.maps.LatLng} other
 * @return {boolean}
 */
google.maps.LatLng.prototype.equals = function(other) {
  return other.lat() == this._lat && other.lng() == this._lng;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @return {string}
 */
google.maps.LatLng.prototype.toString = function() {
  return String(this._lat) + ", " + String(this._lng);
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.LatLng.prototype.lng = function() {
  return this._lng;
};


/**
 * @asparam opt_precision [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {string} 
 * @export
 * @param {number=} opt_precision
 * @return {string}
 */
google.maps.LatLng.prototype.toUrlValue = function(opt_precision) {
  opt_precision = typeof opt_precision !== 'undefined' ? opt_precision : 0;
  return this.toString();
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.LatLng.prototype.lat = function() {
  return this._lat;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.LatLng.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LatLng', qName: 'google.maps.LatLng'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.LatLng', google.maps.LatLng);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.LatLng.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'LatLng': { type: '', declaredBy: 'google.maps.LatLng'},
        'equals': { type: 'Boolean', declaredBy: 'google.maps.LatLng'},
        'toString': { type: 'String', declaredBy: 'google.maps.LatLng'},
        'lng': { type: 'Number', declaredBy: 'google.maps.LatLng'},
        'toUrlValue': { type: 'String', declaredBy: 'google.maps.LatLng'},
        'lat': { type: 'Number', declaredBy: 'google.maps.LatLng'}
      };
    }
  };
};