/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package flex2.compiler.as3;


//     _____ _                   _                 ______      _
//    /  ___(_)                 | |                | ___ \    | |
//    \ `--. _  __ _ _ __   __ _| |_ _   _ _ __ ___| |_/ /   _| | ___  ___
//     `--. \ |/ _` | '_ \ / _` | __| | | | '__/ _ \    / | | | |/ _ \/ __|
//    /\__/ / | (_| | | | | (_| | |_| |_| | | |  __/ |\ \ |_| | |  __/\__ \
//    \____/|_|\__, |_| |_|\__,_|\__|\__,_|_|  \___\_| \_\__,_|_|\___||___/
//              __/ |
//             |___/

/**
 * This is a rule system that lets you customize what a signature contains at a high-level.
 * 
 * It's useful when testing the relationship between generated bytecode and signatures. 
 */
public class SignatureRules
{
    // final for efficiency, and since no one changes these
    // it would be more OO to leave it non-final, but no need right now...
    public final boolean
            // ======== CLASSES ========
            KEEP_CLASSES                = true,
            KEEP_INTERFACES             = true,
            
            // ======= FUNCTIONS =======
            // SCOPE
            KEEP_FUN_SCOPE_USER         = true,
            KEEP_FUN_SCOPE_INTERNAL     = true,
            KEEP_FUN_SCOPE_PRIVATE      = false,
            KEEP_FUN_SCOPE_PROTECTED    = true,
            KEEP_FUN_SCOPE_PUBLIC       = true,
            // PARAMETERS
            KEEP_FUN_PARAM_INITIALIZER  = false,
            //TODO could have an option for keeping "=..." if there is an initializer
    
            // ======= VARIABLES =======
            // SCOPE
            KEEP_VAR_SCOPE_USER         = true,
            KEEP_VAR_SCOPE_INTERNAL     = true,
            KEEP_VAR_SCOPE_PRIVATE      = false,
            KEEP_VAR_SCOPE_PROTECTED    = true,
            KEEP_VAR_SCOPE_PUBLIC       = true,
            // INITIALIZERS 
            //    unimplemented because initializers can be almost any AS3 expressions,
            //    many of which I cannot (correctly) print (e.g. anonymous functions)
            // KEEP_VAR_INIT_VALUES       = false,
            
            // ======== IMPORTS ========
            KEEP_IMPORTS                = true,
            
            // ===== USE NAMESPACE =====
            KEEP_USE_NAMESPACE          = true,
            
            // ======= METADATA ========
            KEEP_METADATA               = true;
}
