/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParser;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaFiles;
import org.javacc.parser.LexGen;
import org.javacc.parser.LookaheadWalk;
import org.javacc.parser.MatchInfo;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.NfaState;
import org.javacc.parser.Options;
import org.javacc.parser.OtherFilesGen;
import org.javacc.parser.ParseEngine;
import org.javacc.parser.ParseException;
import org.javacc.parser.ParseGen;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.Semanticize;

public final class Main {
    private Main() {
    }

    static void help_message() {
        System.out.println("Usage:");
        System.out.println("    javacc option-settings inputfile");
        System.out.println("");
        System.out.println("\"option-settings\" is a sequence of settings separated by spaces.");
        System.out.println("Each option setting must be of one of the following forms:");
        System.out.println("");
        System.out.println("    -optionname=value (e.g., -STATIC=false)");
        System.out.println("    -optionname:value (e.g., -STATIC:false)");
        System.out.println("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        System.out.println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        System.out.println("");
        System.out.println("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        System.out.println("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        System.out.println("option, and must be either an integer, a boolean, or a string value.");
        System.out.println("");
        System.out.println("The integer valued options are:");
        System.out.println("");
        System.out.println("    LOOKAHEAD              (default 1)");
        System.out.println("    CHOICE_AMBIGUITY_CHECK (default 2)");
        System.out.println("    OTHER_AMBIGUITY_CHECK  (default 1)");
        System.out.println("");
        System.out.println("The boolean valued options are:");
        System.out.println("");
        System.out.println("    STATIC                 (default true)");
        System.out.println("    SUPPORT_CLASS_VISIBILITY_PUBLIC (default true)");
        System.out.println("    DEBUG_PARSER           (default false)");
        System.out.println("    DEBUG_LOOKAHEAD        (default false)");
        System.out.println("    DEBUG_TOKEN_MANAGER    (default false)");
        System.out.println("    ERROR_REPORTING        (default true)");
        System.out.println("    JAVA_UNICODE_ESCAPE    (default false)");
        System.out.println("    UNICODE_INPUT          (default false)");
        System.out.println("    IGNORE_CASE            (default false)");
        System.out.println("    COMMON_TOKEN_ACTION    (default false)");
        System.out.println("    USER_TOKEN_MANAGER     (default false)");
        System.out.println("    USER_CHAR_STREAM       (default false)");
        System.out.println("    BUILD_PARSER           (default true)");
        System.out.println("    BUILD_TOKEN_MANAGER    (default true)");
        System.out.println("    TOKEN_MANAGER_USES_PARSER (default false)");
        System.out.println("    SANITY_CHECK           (default true)");
        System.out.println("    FORCE_LA_CHECK         (default false)");
        System.out.println("    CACHE_TOKENS           (default false)");
        System.out.println("    KEEP_LINE_COLUMN       (default true)");
        System.out.println("");
        System.out.println("The string valued options are:");
        System.out.println("");
        System.out.println("    OUTPUT_DIRECTORY       (default Current Directory)");
        System.out.println("    TOKEN_EXTENDS          (default java.lang.Object)");
        System.out.println("    TOKEN_FACTORY          (default none)");
        System.out.println("    JDK_VERSION            (default 1.5)");
        System.out.println("    GRAMMAR_ENCODING       (defaults to platform file encoding)");
        System.out.println("");
        System.out.println("EXAMPLE:");
        System.out.println("    javacc -STATIC=false -LOOKAHEAD:2 -debug_parser mygrammar.jj");
        System.out.println("");
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Main.mainProgram(stringArray);
        System.exit(n);
    }

    public static int mainProgram(String[] stringArray) throws Exception {
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Parser Generator", "");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            System.out.println("");
            Main.help_message();
            return 1;
        }
        System.out.println("(type \"javacc\" with no arguments for help)");
        if (Options.isOption(stringArray[stringArray.length - 1])) {
            System.out.println("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename.");
            return 1;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!Options.isOption(stringArray[i])) {
                System.out.println("Argument \"" + stringArray[i] + "\" must be an option setting.");
                return 1;
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        try {
            File file = new File(stringArray[stringArray.length - 1]);
            if (!file.exists()) {
                System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
                return 1;
            }
            if (file.isDirectory()) {
                System.out.println(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                return 1;
            }
            javaCCParser = new JavaCCParser(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stringArray[stringArray.length - 1]), Options.getGrammarEncoding())));
        }
        catch (SecurityException securityException) {
            System.out.println("Security violation while trying to open " + stringArray[stringArray.length - 1]);
            return 1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
            return 1;
        }
        try {
            System.out.println("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            JavaCCGlobals.fileName = JavaCCGlobals.origFileName = stringArray[stringArray.length - 1];
            JavaCCGlobals.jjtreeGenerated = JavaCCGlobals.isGeneratedBy("JJTree", stringArray[stringArray.length - 1]);
            JavaCCGlobals.toolNames = JavaCCGlobals.getToolNames(stringArray[stringArray.length - 1]);
            javaCCParser.javacc_input();
            JavaCCGlobals.createOutputDir(Options.getOutputDirectory());
            if (Options.getUnicodeInput()) {
                NfaState.unicodeWarningGiven = true;
                System.out.println("Note: UNICODE_INPUT option is specified. Please make sure you create the parser/lexer using a Reader with the correct character encoding.");
            }
            Semanticize.start();
            ParseGen.start();
            LexGen.start();
            OtherFilesGen.start();
            if (JavaCCErrors.get_error_count() == 0 && (Options.getBuildParser() || Options.getBuildTokenManager())) {
                if (JavaCCErrors.get_warning_count() == 0) {
                    System.out.println("Parser generated successfully.");
                } else {
                    System.out.println("Parser generated with 0 errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                }
                return 0;
            }
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return JavaCCErrors.get_error_count() == 0 ? 0 : 1;
        }
        catch (MetaParseException metaParseException) {
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
            System.out.println("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
    }

    public static void reInitAll() {
        Expansion.reInit();
        JavaCCErrors.reInit();
        JavaCCGlobals.reInit();
        Options.init();
        JavaCCParserInternals.reInit();
        RStringLiteral.reInit();
        JavaFiles.reInit();
        LexGen.reInit();
        NfaState.reInit();
        MatchInfo.reInit();
        LookaheadWalk.reInit();
        Semanticize.reInit();
        ParseGen.reInit();
        OtherFilesGen.reInit();
        ParseEngine.reInit();
    }
}

