/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import java.util.HashMap;

public class FaultActions {
    HashMap<String, Integer> m_faults = new HashMap();
    HashMap<String, String> m_description = new HashMap();
    HashMap<String, Integer> m_actions = new HashMap();
    int m_nextBitForAction = 1;

    private FaultActions() {
    }

    Integer get(String o) {
        return this.m_faults.get(o);
    }

    Integer getAction(String o) {
        return this.m_actions.get(o);
    }

    void put(String k, Integer v) {
        this.m_faults.put(k, v);
    }

    public void clear() {
        this.m_faults.clear();
    }

    public int size() {
        return this.m_faults.size();
    }

    public Object[] names() {
        return this.m_faults.keySet().toArray();
    }

    public Object[] actions() {
        return this.m_actions.keySet().toArray();
    }

    public boolean exists(String k) {
        return this.get(k) != null;
    }

    public void putDescription(String k, String v) {
        this.m_description.put(k, v);
    }

    public String getDescription(String k) {
        return this.m_description.get(k) == null ? "" : this.m_description.get(k);
    }

    public void add(String k) {
        this.put(k, new Integer(0));
    }

    public void addAction(String k) {
        Integer v = new Integer(this.m_nextBitForAction++);
        this.m_actions.put(k, v);
    }

    public boolean is(String fault, String action) {
        int mask = this.getAction(action);
        int bits = this.get(fault);
        boolean set = (bits & mask) == mask;
        return set;
    }

    public int action(String fault, String action) {
        Integer bit;
        Integer current = this.get(fault);
        if (current == null) {
            throw new IllegalArgumentException(fault);
        }
        boolean no = action.startsWith("no");
        if (no) {
            action = action.substring(2);
        }
        if ((bit = this.getAction(action)) == null) {
            throw new IllegalArgumentException(action);
        }
        int old = current;
        int mask = bit;
        int n = old & ~mask;
        n = no ? n : n | mask;
        this.put(fault, new Integer(n));
        return n;
    }

    public static class FaultActionsBuilder {
        private final LocalizationManager localizationManager;

        public FaultActionsBuilder(LocalizationManager localizationManager) {
            this.localizationManager = localizationManager;
        }

        public FaultActions build() {
            FaultActions faultActions = new FaultActions();
            this.populateFaultTable(faultActions);
            return faultActions;
        }

        private void populateFaultTable(FaultActions faultActions) {
            faultActions.addAction("stop");
            faultActions.addAction("print");
            faultActions.add("invalid_target");
            faultActions.add("recursion_limit");
            faultActions.add("invalid_with");
            faultActions.add("proto_limit");
            faultActions.add("invalid_url");
            faultActions.add("exception");
            faultActions.add("stack_underflow");
            faultActions.add("zero_divide");
            faultActions.add("script_timeout");
            faultActions.putDescription("invalid_target", this.getLocalizationManager().getLocalizedTextString("invalidTargetFault"));
            faultActions.putDescription("recursion_limit", this.getLocalizationManager().getLocalizedTextString("recursionLimitFault"));
            faultActions.putDescription("invalid_with", this.getLocalizationManager().getLocalizedTextString("invalidWithFault"));
            faultActions.putDescription("proto_limit", this.getLocalizationManager().getLocalizedTextString("protoLimitFault"));
            faultActions.putDescription("invalid_url", this.getLocalizationManager().getLocalizedTextString("invalidUrlFault"));
            faultActions.putDescription("exception", this.getLocalizationManager().getLocalizedTextString("exceptionFault"));
            faultActions.putDescription("stack_underflow", this.getLocalizationManager().getLocalizedTextString("stackUnderflowFault"));
            faultActions.putDescription("zero_divide", this.getLocalizationManager().getLocalizedTextString("divideByZeroFault"));
            faultActions.putDescription("script_timeout", this.getLocalizationManager().getLocalizedTextString("scriptTimeoutFault"));
            faultActions.action("invalid_target", "stop");
            faultActions.action("invalid_target", "print");
            faultActions.action("recursion_limit", "stop");
            faultActions.action("recursion_limit", "print");
            faultActions.action("invalid_with", "stop");
            faultActions.action("invalid_with", "print");
            faultActions.action("proto_limit", "stop");
            faultActions.action("proto_limit", "print");
            faultActions.action("invalid_url", "stop");
            faultActions.action("invalid_url", "print");
            faultActions.action("exception", "stop");
            faultActions.action("exception", "print");
            faultActions.action("stack_underflow", "stop");
            faultActions.action("stack_underflow", "print");
            faultActions.action("zero_divide", "stop");
            faultActions.action("zero_divide", "print");
            faultActions.action("script_timeout", "stop");
            faultActions.action("script_timeout", "print");
        }

        private LocalizationManager getLocalizationManager() {
            return this.localizationManager;
        }
    }
}

