/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.User;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.felix.webconsole.internal.servlet.BasicWebConsoleSecurityProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;

final class OsgiManagerHttpContext
extends ServletContextHelper {
    private final ServiceTracker<WebConsoleSecurityProvider, WebConsoleSecurityProvider> tracker;
    private final String realm;
    private final Bundle bundle;

    OsgiManagerHttpContext(Bundle webConsoleBundle, ServiceTracker<WebConsoleSecurityProvider, WebConsoleSecurityProvider> tracker, String realm) {
        super(webConsoleBundle);
        this.tracker = tracker;
        this.realm = realm;
        this.bundle = webConsoleBundle;
    }

    public URL getResource(String name) {
        URL url = this.bundle.getResource(name);
        if (url == null && name.endsWith("/")) {
            url = this.bundle.getResource(name.substring(0, name.length() - 1));
        }
        return url;
    }

    public boolean handleSecurity(final HttpServletRequest r, HttpServletResponse response) {
        final WebConsoleSecurityProvider provider = (WebConsoleSecurityProvider)this.tracker.getService();
        HttpServletRequestWrapper request = new HttpServletRequestWrapper(r){

            public String getContextPath() {
                return "";
            }

            public String getServletPath() {
                return r.getContextPath();
            }

            public String getPathInfo() {
                return r.getServletPath();
            }
        };
        boolean result = provider instanceof WebConsoleSecurityProvider2 ? ((WebConsoleSecurityProvider2)provider).authenticate((HttpServletRequest)request, response) : this.handleSecurity(provider, (HttpServletRequest)request, response);
        if (result) {
            request.setAttribute(org.apache.felix.webconsole.servlet.User.USER_ATTRIBUTE, (Object)new User((HttpServletRequest)request){
                final /* synthetic */ HttpServletRequest val$request;
                {
                    this.val$request = httpServletRequest;
                }

                @Override
                public boolean authorize(String role) {
                    Object user = this.getUserObject();
                    if (user == null) {
                        return false;
                    }
                    if (provider == null) {
                        return true;
                    }
                    return provider.authorize(user, role);
                }

                @Override
                public Object getUserObject() {
                    return this.val$request.getAttribute("org.apache.felix.webconsole.user");
                }
            });
            request.setAttribute(User.USER_ATTRIBUTE, request.getAttribute(org.apache.felix.webconsole.servlet.User.USER_ATTRIBUTE));
        }
        return result;
    }

    private boolean handleSecurity(WebConsoleSecurityProvider provider, HttpServletRequest request, HttpServletResponse response) {
        int blank;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase("Basic")) {
                try {
                    byte[][] userPass = BasicWebConsoleSecurityProvider.base64Decode(authInfo);
                    String username = BasicWebConsoleSecurityProvider.toString(userPass[0]);
                    if (this.authenticate(provider, username, userPass[1])) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        request.setAttribute("org.apache.felix.webconsole.user", (Object)username);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean authenticate(WebConsoleSecurityProvider provider, String username, byte[] password) {
        if (provider != null) {
            return provider.authenticate(username, BasicWebConsoleSecurityProvider.toString(password)) != null;
        }
        return false;
    }
}

