/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.i18n.LocalizationHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public abstract class SimpleWebConsolePlugin
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 1500463493078823878L;
    private final String label;
    private final String title;
    private final String category;
    private final String[] css;
    private final String labelRes;
    private final int labelResLen;
    private final Object regLock = new Object();
    private ServiceRegistration reg;
    private final Map services = new HashMap();
    private String servletName;

    public SimpleWebConsolePlugin(String label, String title, String[] css) {
        this(label, title, null, css);
    }

    public SimpleWebConsolePlugin(String label, String title, String category, String[] css) {
        if (label == null) {
            throw new NullPointerException("Null label");
        }
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.label = label;
        this.title = title;
        this.category = category;
        this.css = css;
        this.labelRes = '/' + label + '/';
        this.labelResLen = this.labelRes.length() - 1;
    }

    @Override
    public void activate(BundleContext bundleContext) {
        String key;
        LocalizationHelper localization;
        ResourceBundle rb;
        super.activate(bundleContext);
        Bundle bundle = bundleContext.getBundle();
        if (bundle != null && (rb = (localization = new LocalizationHelper(bundle)).getResourceBundle(Locale.getDefault())) != null && this.title != null && this.title.startsWith("%") && rb.containsKey(key = this.title.substring(1))) {
            this.servletName = rb.getString(key);
        }
    }

    @Override
    public String getServletName() {
        if (this.servletName != null) {
            return this.servletName;
        }
        return super.getServletName();
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    protected final String[] getCssReferences() {
        return this.css;
    }

    protected URL getResource(String path) {
        return path != null && path.startsWith(this.labelRes) ? ((Object)((Object)this)).getClass().getResource(path.substring(this.labelResLen)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SimpleWebConsolePlugin register(BundleContext bc) {
        Object object = this.regLock;
        synchronized (object) {
            this.activate(bc);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("felix.webconsole.label", this.getLabel());
            props.put("felix.webconsole.title", this.getTitle());
            if (this.getCategory() != null) {
                props.put("felix.webconsole.category", this.getCategory());
            }
            this.reg = bc.registerService("javax.servlet.Servlet", (Object)this, props);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregister() {
        Object object = this.regLock;
        synchronized (object) {
            this.deactivate();
            if (this.reg != null) {
                this.reg.unregister();
            }
            this.reg = null;
        }
    }

    public final Object getService(String serviceName) {
        ServiceTracker serviceTracker = (ServiceTracker)this.services.get(serviceName);
        if (serviceTracker == null) {
            serviceTracker = new ServiceTracker(this.getBundleContext(), serviceName, null);
            serviceTracker.open();
            this.services.put(serviceName, serviceTracker);
        }
        return serviceTracker.getService();
    }

    @Override
    public void deactivate() {
        Iterator ti = this.services.values().iterator();
        while (ti.hasNext()) {
            ServiceTracker tracker = (ServiceTracker)ti.next();
            tracker.close();
            ti.remove();
        }
        super.deactivate();
    }
}

